/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.math;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.stream.Stream;

public class RandomGenerator {
    private static Random generator = new Random();

    private RandomGenerator() {
    }

    public static void seed(long value) {
        generator = new Random(value);
    }

    public static void randomSeed() {
        generator = new Random();
    }

    public static int getInt(int min, int max) {
        Preconditions.checkArgument((max >= min ? 1 : 0) != 0, (Object)("Invalid range: " + min + " - " + max));
        if (min == max) {
            return min;
        }
        return min + generator.nextInt(max - min);
    }

    public static float getFloat(float min, float max) {
        Preconditions.checkArgument((max >= min ? 1 : 0) != 0, (Object)("Invalid range: " + min + " - " + max));
        if (min == max) {
            return min;
        }
        return min + generator.nextFloat() * (max - min);
    }

    public static boolean chance(float n) {
        Preconditions.checkArgument((n >= 0.0f && n <= 1.0f ? 1 : 0) != 0, (Object)("Number out of range: " + n));
        float value = generator.nextFloat();
        return value <= n;
    }

    public static <T> T pick(List<T> elements) {
        Preconditions.checkArgument((!elements.isEmpty() ? 1 : 0) != 0, (Object)"Cannot pick from empty list");
        int index = RandomGenerator.getInt(0, elements.size());
        return elements.get(index);
    }

    public static <T> T pick(Set<T> elements) {
        Preconditions.checkArgument((!elements.isEmpty() ? 1 : 0) != 0, (Object)"Cannot pick from empty set");
        Object[] buffer = elements.toArray(new Object[0]);
        int index = RandomGenerator.getInt(0, buffer.length);
        return (T)buffer[index];
    }

    public static <T> T pick(Iterable<T> elements) {
        return RandomGenerator.pick(ImmutableList.copyOf(elements));
    }

    public static <T> T pick(Stream<T> elements) {
        return RandomGenerator.pick(elements.toList());
    }

    public static <T> T pick(Map<T, Integer> choices) {
        Preconditions.checkArgument((!choices.isEmpty() ? 1 : 0) != 0, (Object)"Cannot pick from empty map");
        ArrayList<T> elements = new ArrayList<T>();
        for (T element : choices.keySet()) {
            for (int i = 0; i < choices.get(element); ++i) {
                elements.add(element);
            }
        }
        return (T)RandomGenerator.pick(elements);
    }

    public static <T> List<T> shuffle(List<T> original) {
        ArrayList<T> shuffled = new ArrayList<T>();
        shuffled.addAll(original);
        if (original.size() >= 2) {
            Collections.shuffle(shuffled, generator);
        }
        return shuffled;
    }
}

