/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.math;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import nl.colorize.multimedialib.math.Line;
import nl.colorize.multimedialib.math.Point2D;
import nl.colorize.multimedialib.math.Rect;
import nl.colorize.multimedialib.math.Shape;

public final class SegmentedLine
implements Shape {
    private final List<Point2D> points;
    private final List<Line> segments;

    public SegmentedLine(List<Point2D> points) {
        Preconditions.checkArgument((points.size() >= 2 ? 1 : 0) != 0, (Object)("Insufficient points: " + points.size()));
        this.points = points;
        this.segments = new ArrayList<Line>();
        for (int i = 1; i < points.size(); ++i) {
            this.segments.add(new Line(points.get(i - 1), points.get(i)));
        }
    }

    public Point2D getHead() {
        return this.points.get(0);
    }

    @Override
    public boolean contains(Point2D p) {
        return this.points.contains(p);
    }

    @Override
    public Rect getBoundingBox() {
        float minX = this.points.get(0).getX();
        float maxX = this.points.get(0).getX();
        float minY = this.points.get(0).getY();
        float maxY = this.points.get(0).getY();
        for (int i = 1; i < this.points.size(); ++i) {
            minX = Math.min(minX, this.points.get(i).getX());
            maxX = Math.max(maxX, this.points.get(i).getX());
            minY = Math.min(minY, this.points.get(i).getY());
            maxY = Math.max(maxY, this.points.get(i).getY());
        }
        return Rect.fromPoints(minX, minY, maxX, maxY);
    }

    @Override
    public SegmentedLine reposition(Point2D offset) {
        List<Point2D> pointsCopy = this.points.stream().map(p -> new Point2D(p.getX() + offset.getX(), p.getY() + offset.getY())).toList();
        return new SegmentedLine(pointsCopy);
    }

    public List<Point2D> getPoints() {
        return this.points;
    }

    public List<Line> getSegments() {
        return this.segments;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SegmentedLine)) {
            return false;
        }
        SegmentedLine other = (SegmentedLine)o;
        List<Point2D> this$points = this.getPoints();
        List<Point2D> other$points = other.getPoints();
        if (this$points == null ? other$points != null : !((Object)this$points).equals(other$points)) {
            return false;
        }
        List<Line> this$segments = this.getSegments();
        List<Line> other$segments = other.getSegments();
        return !(this$segments == null ? other$segments != null : !((Object)this$segments).equals(other$segments));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Point2D> $points = this.getPoints();
        result = result * 59 + ($points == null ? 43 : ((Object)$points).hashCode());
        List<Line> $segments = this.getSegments();
        result = result * 59 + ($segments == null ? 43 : ((Object)$segments).hashCode());
        return result;
    }

    public String toString() {
        return "SegmentedLine(points=" + this.getPoints() + ", segments=" + this.getSegments() + ")";
    }
}

