/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.headless;

import com.google.common.annotations.VisibleForTesting;
import java.util.UUID;
import nl.colorize.multimedialib.math.Region;
import nl.colorize.multimedialib.renderer.FilePointer;
import nl.colorize.multimedialib.renderer.headless.HeadlessAudio;
import nl.colorize.multimedialib.renderer.java2d.StandardMediaLoader;
import nl.colorize.multimedialib.stage.Audio;
import nl.colorize.multimedialib.stage.ColorRGB;
import nl.colorize.multimedialib.stage.FontStyle;
import nl.colorize.multimedialib.stage.Image;
import nl.colorize.multimedialib.stage.OutlineFont;

@VisibleForTesting
public class HeadlessMediaLoader
extends StandardMediaLoader {
    private boolean graphicsEnvironmentEnabled;

    public HeadlessMediaLoader(boolean graphicsEnvironmentEnabled) {
        this.graphicsEnvironmentEnabled = graphicsEnvironmentEnabled;
    }

    @Override
    public Image loadImage(FilePointer file) {
        if (this.graphicsEnvironmentEnabled) {
            return super.loadImage(file);
        }
        if (file == null) {
            return new HeadlessImage();
        }
        return new HeadlessImage(file.path());
    }

    @Override
    public Audio loadAudio(FilePointer file) {
        return new HeadlessAudio();
    }

    @Override
    public OutlineFont loadFont(FilePointer file, FontStyle style) {
        return super.loadFont(file, style);
    }

    private static class HeadlessImage
    implements Image {
        private String name;
        private int width;
        private int height;

        public HeadlessImage(String name, int width, int height) {
            this.name = name;
            this.width = width;
            this.height = height;
        }

        public HeadlessImage(String name) {
            this(name, 100, 100);
        }

        public HeadlessImage() {
            this("HeadlessImage-" + UUID.randomUUID(), 100, 100);
        }

        @Override
        public Region getRegion() {
            return new Region(0, 0, this.width, this.height);
        }

        @Override
        public Image extractRegion(Region region) {
            return new HeadlessImage(this.name + "[" + region + "]", region.width(), region.height());
        }

        @Override
        public ColorRGB getColor(int x, int y) {
            return ColorRGB.BLACK;
        }

        @Override
        public int getAlpha(int x, int y) {
            return 100;
        }

        public String toString() {
            return this.name;
        }
    }
}

