/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.headless;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.util.Optional;
import nl.colorize.multimedialib.math.Point2D;
import nl.colorize.multimedialib.math.Rect;
import nl.colorize.multimedialib.renderer.Canvas;
import nl.colorize.multimedialib.renderer.DisplayMode;
import nl.colorize.multimedialib.renderer.ErrorHandler;
import nl.colorize.multimedialib.renderer.GraphicsMode;
import nl.colorize.multimedialib.renderer.InputDevice;
import nl.colorize.multimedialib.renderer.KeyCode;
import nl.colorize.multimedialib.renderer.Network;
import nl.colorize.multimedialib.renderer.Renderer;
import nl.colorize.multimedialib.renderer.headless.HeadlessMediaLoader;
import nl.colorize.multimedialib.renderer.java2d.StandardNetwork;
import nl.colorize.multimedialib.scene.Scene;
import nl.colorize.multimedialib.scene.SceneContext;
import nl.colorize.multimedialib.stage.StageVisitor;
import nl.colorize.util.Stopwatch;

@VisibleForTesting
public class HeadlessRenderer
implements Renderer,
InputDevice {
    private final GraphicsMode graphicsMode = GraphicsMode.HEADLESS;
    private DisplayMode displayMode;
    private StageVisitor graphics;
    private HeadlessMediaLoader mediaLoader;
    private Network network;
    private SceneContext context;
    private boolean touchAvailable;
    private boolean keyboardAvailable;
    private Point2D pointer;
    private boolean pointerPressed;
    private boolean pointerReleased;
    public static final int DEFAULT_WIDTH = 800;
    public static final int DEFAULT_HEIGHT = 600;
    public static final int DEFAULT_FRAMERATE = 30;

    public HeadlessRenderer(DisplayMode displayMode, boolean graphicsEnvironmentEnabled) {
        this.displayMode = displayMode;
        this.graphics = null;
        this.mediaLoader = new HeadlessMediaLoader(graphicsEnvironmentEnabled);
        this.network = new StandardNetwork();
        this.context = new SceneContext(this, new Stopwatch());
        this.touchAvailable = false;
        this.keyboardAvailable = false;
        this.pointer = new Point2D(0.0f, 0.0f);
        this.pointerPressed = false;
        this.pointerReleased = false;
    }

    public HeadlessRenderer(Canvas canvas, int framerate) {
        this(new DisplayMode(canvas, framerate), true);
    }

    public HeadlessRenderer() {
        this(Canvas.flexible(800, 600), 30);
    }

    @Override
    public void start(Scene initialScene, ErrorHandler errorHandler) {
        this.context.changeScene(initialScene);
        this.doFrame();
    }

    @Override
    public void takeScreenshot(File outputFile) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void terminate() {
        throw new UnsupportedOperationException();
    }

    public void doFrame() {
        this.context.update(1.0f / (float)this.displayMode.framerate());
    }

    @Override
    public void update(float deltaTime) {
    }

    @Override
    public InputDevice getInput() {
        return this;
    }

    @Override
    public Optional<Point2D> getPointer() {
        return Optional.ofNullable(this.pointer);
    }

    @Override
    public boolean isPointerPressed(Rect area) {
        return this.pointerPressed;
    }

    @Override
    public boolean isPointerReleased(Rect area) {
        return this.pointerReleased;
    }

    @Override
    public void clearPointerReleased() {
        this.pointerPressed = false;
        this.pointerReleased = false;
    }

    @Override
    public boolean isKeyPressed(KeyCode keyCode) {
        return false;
    }

    @Override
    public boolean isKeyReleased(KeyCode keyCode) {
        return false;
    }

    @Override
    public String requestTextInput(String label, String initialValue) {
        return null;
    }

    @Override
    public GraphicsMode getGraphicsMode() {
        return this.graphicsMode;
    }

    @Override
    public DisplayMode getDisplayMode() {
        return this.displayMode;
    }

    @Override
    public StageVisitor getGraphics() {
        return this.graphics;
    }

    @Override
    public HeadlessMediaLoader getMediaLoader() {
        return this.mediaLoader;
    }

    @Override
    public Network getNetwork() {
        return this.network;
    }

    public SceneContext getContext() {
        return this.context;
    }

    @Override
    public boolean isTouchAvailable() {
        return this.touchAvailable;
    }

    @Override
    public boolean isKeyboardAvailable() {
        return this.keyboardAvailable;
    }

    @Override
    public boolean isPointerPressed() {
        return this.pointerPressed;
    }

    @Override
    public boolean isPointerReleased() {
        return this.pointerReleased;
    }

    public void setDisplayMode(DisplayMode displayMode) {
        this.displayMode = displayMode;
    }

    public void setGraphics(StageVisitor graphics) {
        this.graphics = graphics;
    }

    public void setMediaLoader(HeadlessMediaLoader mediaLoader) {
        this.mediaLoader = mediaLoader;
    }

    public void setNetwork(Network network) {
        this.network = network;
    }

    public void setContext(SceneContext context) {
        this.context = context;
    }

    public void setTouchAvailable(boolean touchAvailable) {
        this.touchAvailable = touchAvailable;
    }

    public void setKeyboardAvailable(boolean keyboardAvailable) {
        this.keyboardAvailable = keyboardAvailable;
    }

    public void setPointer(Point2D pointer) {
        this.pointer = pointer;
    }

    public void setPointerPressed(boolean pointerPressed) {
        this.pointerPressed = pointerPressed;
    }

    public void setPointerReleased(boolean pointerReleased) {
        this.pointerReleased = pointerReleased;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HeadlessRenderer)) {
            return false;
        }
        HeadlessRenderer other = (HeadlessRenderer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isTouchAvailable() != other.isTouchAvailable()) {
            return false;
        }
        if (this.isKeyboardAvailable() != other.isKeyboardAvailable()) {
            return false;
        }
        if (this.isPointerPressed() != other.isPointerPressed()) {
            return false;
        }
        if (this.isPointerReleased() != other.isPointerReleased()) {
            return false;
        }
        GraphicsMode this$graphicsMode = this.getGraphicsMode();
        GraphicsMode other$graphicsMode = other.getGraphicsMode();
        if (this$graphicsMode == null ? other$graphicsMode != null : !((Object)((Object)this$graphicsMode)).equals((Object)other$graphicsMode)) {
            return false;
        }
        DisplayMode this$displayMode = this.getDisplayMode();
        DisplayMode other$displayMode = other.getDisplayMode();
        if (this$displayMode == null ? other$displayMode != null : !((Object)this$displayMode).equals(other$displayMode)) {
            return false;
        }
        StageVisitor this$graphics = this.getGraphics();
        StageVisitor other$graphics = other.getGraphics();
        if (this$graphics == null ? other$graphics != null : !this$graphics.equals(other$graphics)) {
            return false;
        }
        HeadlessMediaLoader this$mediaLoader = this.getMediaLoader();
        HeadlessMediaLoader other$mediaLoader = other.getMediaLoader();
        if (this$mediaLoader == null ? other$mediaLoader != null : !this$mediaLoader.equals(other$mediaLoader)) {
            return false;
        }
        Network this$network = this.getNetwork();
        Network other$network = other.getNetwork();
        if (this$network == null ? other$network != null : !this$network.equals(other$network)) {
            return false;
        }
        SceneContext this$context = this.getContext();
        SceneContext other$context = other.getContext();
        if (this$context == null ? other$context != null : !this$context.equals(other$context)) {
            return false;
        }
        Optional<Point2D> this$pointer = this.getPointer();
        Optional<Point2D> other$pointer = other.getPointer();
        return !(this$pointer == null ? other$pointer != null : !((Object)this$pointer).equals(other$pointer));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HeadlessRenderer;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isTouchAvailable() ? 79 : 97);
        result = result * 59 + (this.isKeyboardAvailable() ? 79 : 97);
        result = result * 59 + (this.isPointerPressed() ? 79 : 97);
        result = result * 59 + (this.isPointerReleased() ? 79 : 97);
        GraphicsMode $graphicsMode = this.getGraphicsMode();
        result = result * 59 + ($graphicsMode == null ? 43 : ((Object)((Object)$graphicsMode)).hashCode());
        DisplayMode $displayMode = this.getDisplayMode();
        result = result * 59 + ($displayMode == null ? 43 : ((Object)$displayMode).hashCode());
        StageVisitor $graphics = this.getGraphics();
        result = result * 59 + ($graphics == null ? 43 : $graphics.hashCode());
        HeadlessMediaLoader $mediaLoader = this.getMediaLoader();
        result = result * 59 + ($mediaLoader == null ? 43 : $mediaLoader.hashCode());
        Network $network = this.getNetwork();
        result = result * 59 + ($network == null ? 43 : $network.hashCode());
        SceneContext $context = this.getContext();
        result = result * 59 + ($context == null ? 43 : $context.hashCode());
        Optional<Point2D> $pointer = this.getPointer();
        result = result * 59 + ($pointer == null ? 43 : ((Object)$pointer).hashCode());
        return result;
    }

    public String toString() {
        return "HeadlessRenderer(graphicsMode=" + this.getGraphicsMode() + ", displayMode=" + this.getDisplayMode() + ", graphics=" + this.getGraphics() + ", mediaLoader=" + this.getMediaLoader() + ", network=" + this.getNetwork() + ", context=" + this.getContext() + ", touchAvailable=" + this.isTouchAvailable() + ", keyboardAvailable=" + this.isKeyboardAvailable() + ", pointer=" + this.getPointer() + ", pointerPressed=" + this.isPointerPressed() + ", pointerReleased=" + this.isPointerReleased() + ")";
    }
}

