/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.libgdx;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.assets.loaders.resolvers.InternalFileHandleResolver;
import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.freetype.FreeTypeFontGenerator;
import com.badlogic.gdx.graphics.g3d.Attribute;
import com.badlogic.gdx.graphics.g3d.Material;
import com.badlogic.gdx.graphics.g3d.Model;
import com.badlogic.gdx.graphics.g3d.ModelInstance;
import com.badlogic.gdx.graphics.g3d.attributes.BlendingAttribute;
import com.badlogic.gdx.graphics.g3d.loader.G3dModelLoader;
import com.badlogic.gdx.utils.BaseJsonReader;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.UBJsonReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import net.mgsx.gltf.loaders.gltf.GLTFLoader;
import net.mgsx.gltf.scene3d.scene.SceneAsset;
import nl.colorize.multimedialib.renderer.FilePointer;
import nl.colorize.multimedialib.renderer.GeometryBuilder;
import nl.colorize.multimedialib.renderer.MediaException;
import nl.colorize.multimedialib.renderer.MediaLoader;
import nl.colorize.multimedialib.renderer.java2d.StandardMediaLoader;
import nl.colorize.multimedialib.renderer.libgdx.GDXAudio;
import nl.colorize.multimedialib.renderer.libgdx.GDXBitmapFont;
import nl.colorize.multimedialib.renderer.libgdx.GDXGeometryBuilder;
import nl.colorize.multimedialib.renderer.libgdx.GDXImage;
import nl.colorize.multimedialib.renderer.libgdx.GDXModel;
import nl.colorize.multimedialib.stage.Audio;
import nl.colorize.multimedialib.stage.ColorRGB;
import nl.colorize.multimedialib.stage.FontStyle;
import nl.colorize.multimedialib.stage.Image;
import nl.colorize.multimedialib.stage.OutlineFont;
import nl.colorize.multimedialib.stage.PolygonModel;
import nl.colorize.util.stats.Cache;

public class GDXMediaLoader
implements MediaLoader,
Disposable {
    private List<Disposable> loaded = new ArrayList<Disposable>();
    private Cache<FontCacheKey, BitmapFont> fontCache = Cache.from(this::generateBitmapFont, (int)100);
    private StandardMediaLoader appDataDelegate = new StandardMediaLoader();
    private static final Texture.TextureFilter TEXTURE_FILTER = Texture.TextureFilter.Linear;
    private static final int FONT_CACHE_SIZE = 100;
    private static final String CHARSET = "UTF-8";

    @Override
    public Image loadImage(FilePointer file) {
        Texture texture = new Texture(this.getFileHandle(file));
        texture.setFilter(TEXTURE_FILTER, TEXTURE_FILTER);
        this.loaded.add((Disposable)texture);
        return new GDXImage(texture);
    }

    @Override
    public Audio loadAudio(FilePointer file) {
        Sound sound = Gdx.audio.newSound(this.getFileHandle(file));
        this.loaded.add((Disposable)sound);
        return new GDXAudio(sound);
    }

    @Override
    public OutlineFont loadFont(FilePointer file, FontStyle style) {
        return new GDXBitmapFont(this, this.getFileHandle(file), style);
    }

    protected BitmapFont getBitmapFont(FileHandle source, FontStyle style) {
        FontCacheKey cacheKey = new FontCacheKey(source, style);
        return (BitmapFont)this.fontCache.get((Object)cacheKey);
    }

    private BitmapFont generateBitmapFont(FontCacheKey cacheKey) {
        FreeTypeFontGenerator.FreeTypeFontParameter config = new FreeTypeFontGenerator.FreeTypeFontParameter();
        config.size = cacheKey.style.size();
        config.color = GDXMediaLoader.toColor(cacheKey.style.color());
        FreeTypeFontGenerator fontGenerator = new FreeTypeFontGenerator(cacheKey.source());
        BitmapFont bitmapFont = fontGenerator.generateFont(config);
        fontGenerator.dispose();
        return bitmapFont;
    }

    @Override
    public String loadText(FilePointer file) {
        return this.getFileHandle(file).readString(CHARSET);
    }

    @Override
    public PolygonModel loadModel(FilePointer file) {
        Model model = this.loadModel(this.getFileHandle(file));
        return this.createInstance(model);
    }

    private Model loadModel(FileHandle file) {
        if (file.toString().endsWith(".g3db")) {
            G3dModelLoader g3dLoader = new G3dModelLoader((BaseJsonReader)new UBJsonReader(), (FileHandleResolver)new InternalFileHandleResolver());
            return g3dLoader.loadModel(file);
        }
        if (file.toString().endsWith(".gltf")) {
            GLTFLoader gltfLoader = new GLTFLoader();
            SceneAsset sceneAsset = gltfLoader.load(file, true);
            return sceneAsset.scene.model;
        }
        throw new MediaException("Unsupported model file format: " + file);
    }

    @Override
    public GeometryBuilder getGeometryBuilder() {
        return new GDXGeometryBuilder(this);
    }

    protected PolygonModel createInstance(Model model) {
        ModelInstance instance = new ModelInstance(model);
        ((Material)instance.materials.get(0)).set((Attribute)new BlendingAttribute(770, 771));
        this.loaded.add((Disposable)model);
        return new GDXModel(instance);
    }

    @Override
    public boolean containsResourceFile(FilePointer file) {
        return this.getFileHandle(file).exists();
    }

    @Override
    public Properties loadApplicationData(String appName) {
        return this.appDataDelegate.loadApplicationData(appName);
    }

    @Override
    public void saveApplicationData(String appName, Properties data) {
        this.appDataDelegate.saveApplicationData(appName, data);
    }

    private FileHandle getFileHandle(FilePointer file) {
        return Gdx.files.internal(file.path());
    }

    public void dispose() {
        this.loaded.forEach(Disposable::dispose);
        this.loaded.clear();
        this.fontCache.forgetAll();
    }

    public static Color toColor(ColorRGB color) {
        return new Color((float)color.r() / 255.0f, (float)color.g() / 255.0f, (float)color.b() / 255.0f, 1.0f);
    }

    private record FontCacheKey(FileHandle source, FontStyle style) {
    }
}

