/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.libgdx;

import com.badlogic.gdx.ApplicationListener;
import com.badlogic.gdx.Files;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3Application;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3ApplicationConfiguration;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.PixmapIO;
import com.badlogic.gdx.graphics.glutils.HdpiMode;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import nl.colorize.multimedialib.renderer.Canvas;
import nl.colorize.multimedialib.renderer.DisplayMode;
import nl.colorize.multimedialib.renderer.ErrorHandler;
import nl.colorize.multimedialib.renderer.GraphicsMode;
import nl.colorize.multimedialib.renderer.InputDevice;
import nl.colorize.multimedialib.renderer.MediaLoader;
import nl.colorize.multimedialib.renderer.Network;
import nl.colorize.multimedialib.renderer.Renderer;
import nl.colorize.multimedialib.renderer.WindowOptions;
import nl.colorize.multimedialib.renderer.java2d.StandardNetwork;
import nl.colorize.multimedialib.renderer.libgdx.GDXGraphics;
import nl.colorize.multimedialib.renderer.libgdx.GDXInput;
import nl.colorize.multimedialib.renderer.libgdx.GDXMediaLoader;
import nl.colorize.multimedialib.scene.Scene;
import nl.colorize.multimedialib.scene.SceneContext;
import nl.colorize.multimedialib.stage.Stage;
import nl.colorize.multimedialib.stage.StageVisitor;
import nl.colorize.util.LogHelper;
import nl.colorize.util.Platform;
import nl.colorize.util.Stopwatch;

public class GDXRenderer
implements Renderer,
ApplicationListener {
    private GraphicsMode graphicsMode;
    private Canvas canvas;
    private int framerate;
    private WindowOptions window;
    private GDXGraphics graphicsContext;
    private GDXInput input;
    private GDXMediaLoader mediaLoader;
    private SceneContext context;
    private Scene initialScene;
    private List<FileHandle> requestedScreenshots;
    private static final Logger LOGGER = LogHelper.getLogger(GDXRenderer.class);

    public GDXRenderer(GraphicsMode graphicsMode, DisplayMode displayMode, WindowOptions window) {
        this.graphicsMode = graphicsMode;
        this.canvas = displayMode.canvas();
        this.framerate = displayMode.framerate();
        this.window = window;
        this.requestedScreenshots = new ArrayList<FileHandle>();
    }

    @Override
    public void start(Scene initialScene, ErrorHandler errorHandler) {
        this.initialScene = initialScene;
        int windowWidth = Math.round((float)this.canvas.getWidth() * this.getDesktopScaleFactor());
        int windowHeight = Math.round((float)this.canvas.getHeight() * this.getDesktopScaleFactor());
        Lwjgl3ApplicationConfiguration config = new Lwjgl3ApplicationConfiguration();
        config.setWindowedMode(windowWidth, windowHeight);
        config.setDecorated(true);
        config.setIdleFPS(this.framerate);
        config.setForegroundFPS(this.framerate);
        config.setHdpiMode(HdpiMode.Pixels);
        config.setTitle(this.window.title());
        if (this.window.iconFile() != null) {
            config.setWindowIcon(Files.FileType.Internal, new String[]{this.window.iconFile().path()});
        }
        try {
            new Lwjgl3Application((ApplicationListener)this, config);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error during animation loop", e);
            errorHandler.onError(this.context, e);
        }
    }

    private float getDesktopScaleFactor() {
        if (Platform.isWindows()) {
            return (float)GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getDefaultTransform().getScaleX();
        }
        return 1.0f;
    }

    public void create() {
        this.resize(this.canvas.getWidth(), this.canvas.getHeight());
        this.input = new GDXInput(this.canvas);
        this.mediaLoader = new GDXMediaLoader();
        this.graphicsContext = new GDXGraphics(this.canvas);
        this.context = new SceneContext(this, new Stopwatch());
        this.context.changeScene(this.initialScene);
    }

    public void dispose() {
        this.graphicsContext.dispose();
        this.mediaLoader.dispose();
    }

    public void resize(int width, int height) {
        this.canvas.resizeScreen(width, height);
    }

    public void pause() {
    }

    public void resume() {
    }

    public void render() {
        Gdx.gl.glViewport(0, 0, Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16640);
        this.context.syncFrame();
        this.renderStage(this.context.getStage());
        this.graphicsContext.switchMode(false, false);
        this.renderRequestedScreenshots();
    }

    private void renderStage(Stage stage) {
        this.context.getFrameStats().markStart("$$frameRender");
        if (this.graphicsMode == GraphicsMode.MODE_3D) {
            this.graphicsContext.render3D(stage.getWorld());
        }
        stage.visit(this.graphicsContext);
        this.context.getFrameStats().markEnd("$$frameRender");
    }

    @Override
    public GraphicsMode getGraphicsMode() {
        return this.graphicsMode;
    }

    @Override
    public DisplayMode getDisplayMode() {
        return new DisplayMode(this.canvas, this.framerate);
    }

    @Override
    public StageVisitor getGraphics() {
        return this.graphicsContext;
    }

    @Override
    public InputDevice getInput() {
        return this.input;
    }

    @Override
    public MediaLoader getMediaLoader() {
        return this.mediaLoader;
    }

    @Override
    public Network getNetwork() {
        return new StandardNetwork();
    }

    @Override
    public void takeScreenshot(File outputFile) {
        this.requestedScreenshots.add(new FileHandle(outputFile));
    }

    private void renderRequestedScreenshots() {
        if (this.requestedScreenshots.isEmpty()) {
            return;
        }
        int width = Gdx.graphics.getBackBufferWidth();
        int height = Gdx.graphics.getBackBufferHeight();
        Pixmap pixels = Pixmap.createFromFrameBuffer((int)0, (int)0, (int)width, (int)height);
        for (FileHandle outputFile : this.requestedScreenshots) {
            PixmapIO.writePNG((FileHandle)outputFile, (Pixmap)pixels, (int)-1, (boolean)true);
        }
        pixels.dispose();
        this.requestedScreenshots.clear();
    }

    @Override
    public void terminate() {
        System.exit(0);
    }
}

