/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.scene;

import com.google.common.base.Preconditions;
import nl.colorize.multimedialib.renderer.Canvas;
import nl.colorize.multimedialib.scene.InteractiveObject;
import nl.colorize.multimedialib.scene.SceneContext;
import nl.colorize.multimedialib.stage.Container;
import nl.colorize.multimedialib.stage.Graphic2D;

public class OrientationLockScreen
implements InteractiveObject {
    private Container container;

    public OrientationLockScreen(Graphic2D ... graphics) {
        Preconditions.checkArgument((graphics.length > 0 ? 1 : 0) != 0, (Object)"Orientation lock screen must have graphics");
        this.container = new Container();
        for (Graphic2D graphic : graphics) {
            this.container.addChild(graphic);
        }
    }

    @Override
    public void update(SceneContext context, float deltaTime) {
        Canvas canvas = context.getCanvas();
        this.container.getTransform().setVisible(canvas.getWidth() < canvas.getHeight());
        this.container.getTransform().setPosition(canvas.getCenter());
    }

    @Override
    public Container getContainer() {
        return this.container;
    }
}

