/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.scene;

import com.google.common.base.Preconditions;
import nl.colorize.multimedialib.math.Buffer;
import nl.colorize.multimedialib.math.Line;
import nl.colorize.multimedialib.math.Point2D;
import nl.colorize.multimedialib.renderer.InputDevice;
import nl.colorize.multimedialib.scene.Scene;
import nl.colorize.multimedialib.scene.SceneContext;

public class SwipeTracker
implements Scene {
    private float tolerance;
    private Point2D currentSwipeStart;
    private Buffer<Line> swipes;

    public SwipeTracker(float tolerance) {
        Preconditions.checkArgument((tolerance >= 10.0f ? 1 : 0) != 0, (Object)("Invalid tolerance: " + tolerance));
        this.tolerance = tolerance;
        this.swipes = new Buffer();
    }

    @Override
    public void update(SceneContext context, float deltaTime) {
        InputDevice input = context.getInput();
        Point2D pointer = input.getPointer().orElse(null);
        if (pointer == null) {
            this.currentSwipeStart = null;
        } else if (this.currentSwipeStart == null) {
            this.checkSwipeStart(input, pointer);
        } else {
            this.updateCurrentSwipe(input, pointer);
        }
    }

    private void checkSwipeStart(InputDevice input, Point2D pointer) {
        if (input.isPointerPressed()) {
            this.currentSwipeStart = pointer;
        }
    }

    private void updateCurrentSwipe(InputDevice input, Point2D pointer) {
        if (input.isPointerReleased()) {
            if (this.currentSwipeStart.distanceTo(pointer) >= this.tolerance) {
                Line completedSwipe = new Line(this.currentSwipeStart, pointer);
                this.swipes.push(completedSwipe);
            }
            this.currentSwipeStart = null;
        } else if (!input.isPointerPressed()) {
            this.currentSwipeStart = null;
        }
    }

    public Buffer<Line> getSwipes() {
        return this.swipes;
    }
}

