/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.stage;

import com.google.common.base.Preconditions;
import java.util.Map;
import nl.colorize.multimedialib.math.Circle;
import nl.colorize.multimedialib.math.Line;
import nl.colorize.multimedialib.math.Polygon;
import nl.colorize.multimedialib.math.Rect;
import nl.colorize.multimedialib.math.SegmentedLine;
import nl.colorize.multimedialib.math.Shape;
import nl.colorize.multimedialib.stage.ColorRGB;
import nl.colorize.multimedialib.stage.Graphic2D;
import nl.colorize.multimedialib.stage.StageLocation;
import nl.colorize.multimedialib.stage.Transform;

public class Primitive
implements Graphic2D {
    private final StageLocation location = new StageLocation();
    private Shape shape;
    private ColorRGB color;
    private float stroke;
    public static final int TYPE_LINE = 1;
    public static final int TYPE_RECT = 2;
    public static final int TYPE_CIRCLE = 3;
    public static final int TYPE_POLYGON = 4;
    public static final int TYPE_SEGMENTED_LINE = 5;
    private static final Map<Class<? extends Shape>, Integer> TYPE_MAPPING = Map.of(Line.class, 1, Rect.class, 2, Circle.class, 3, Polygon.class, 4, SegmentedLine.class, 5);

    public Primitive(Shape shape, ColorRGB color) {
        this.shape = shape;
        this.color = color;
        this.stroke = 1.0f;
    }

    public Primitive(Shape shape, ColorRGB color, float alpha) {
        this(shape, color);
        this.getTransform().setAlpha(alpha);
    }

    public int getShapeType() {
        Integer type = TYPE_MAPPING.get(this.shape.getClass());
        Preconditions.checkState((type != null ? 1 : 0) != 0, (Object)("Unknown shape: " + this.shape.getClass()));
        return type;
    }

    @Override
    public void update(float deltaTime) {
    }

    @Override
    public Rect getStageBounds() {
        Transform globalTransform = this.getGlobalTransform();
        return this.shape.reposition(globalTransform.getPosition()).getBoundingBox();
    }

    public String toString() {
        return "Primitive [" + this.shape.toString() + "]";
    }

    @Override
    public StageLocation getLocation() {
        return this.location;
    }

    public Shape getShape() {
        return this.shape;
    }

    public ColorRGB getColor() {
        return this.color;
    }

    public float getStroke() {
        return this.stroke;
    }

    public void setShape(Shape shape) {
        this.shape = shape;
    }

    public void setColor(ColorRGB color) {
        this.color = color;
    }

    public void setStroke(float stroke) {
        this.stroke = stroke;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Primitive)) {
            return false;
        }
        Primitive other = (Primitive)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getStroke(), other.getStroke()) != 0) {
            return false;
        }
        StageLocation this$location = this.getLocation();
        StageLocation other$location = other.getLocation();
        if (this$location == null ? other$location != null : !this$location.equals(other$location)) {
            return false;
        }
        Shape this$shape = this.getShape();
        Shape other$shape = other.getShape();
        if (this$shape == null ? other$shape != null : !this$shape.equals(other$shape)) {
            return false;
        }
        ColorRGB this$color = this.getColor();
        ColorRGB other$color = other.getColor();
        return !(this$color == null ? other$color != null : !((Object)this$color).equals(other$color));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Primitive;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getStroke());
        StageLocation $location = this.getLocation();
        result = result * 59 + ($location == null ? 43 : $location.hashCode());
        Shape $shape = this.getShape();
        result = result * 59 + ($shape == null ? 43 : $shape.hashCode());
        ColorRGB $color = this.getColor();
        result = result * 59 + ($color == null ? 43 : ((Object)$color).hashCode());
        return result;
    }
}

