/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.stage;

import java.util.Set;
import java.util.stream.Collectors;
import nl.colorize.multimedialib.math.Point2D;
import nl.colorize.multimedialib.math.Rect;
import nl.colorize.multimedialib.scene.FiniteStateMachine;
import nl.colorize.multimedialib.scene.State;
import nl.colorize.multimedialib.stage.Animation;
import nl.colorize.multimedialib.stage.Graphic2D;
import nl.colorize.multimedialib.stage.Image;
import nl.colorize.multimedialib.stage.StageLocation;
import nl.colorize.multimedialib.stage.Transform;

public class Sprite
implements Graphic2D {
    private StageLocation location = new StageLocation();
    private FiniteStateMachine<Animation> stateMachine = new FiniteStateMachine();
    private static final String DEFAULT_STATE = "$$default";

    public Sprite() {
    }

    public Sprite(Animation anim) {
        this();
        this.addState(DEFAULT_STATE, anim);
    }

    public Sprite(Image image) {
        this();
        this.addState(DEFAULT_STATE, image);
    }

    public void addState(String name, Animation graphics) {
        this.stateMachine.register(State.of(name, graphics));
    }

    public void addState(String name, Image stateGraphics) {
        this.addState(name, new Animation(stateGraphics));
    }

    @Override
    public void update(float deltaTime) {
        this.stateMachine.update(deltaTime);
    }

    public void changeState(String state) {
        this.stateMachine.changeState(state);
    }

    public void resetState() {
        this.stateMachine.resetActiveState();
    }

    public String getActiveState() {
        return this.stateMachine.getActiveState().name();
    }

    public Set<String> getPossibleStates() {
        return this.stateMachine.getPossibleStates().stream().map(State::name).collect(Collectors.toSet());
    }

    public boolean hasState(String stateName) {
        return this.stateMachine.hasPossibleState(stateName);
    }

    public Animation getStateGraphics(String stateName) {
        return this.stateMachine.getPossibleState(stateName).properties();
    }

    public Animation getActiveStateGraphics() {
        return this.getStateGraphics(this.getActiveState());
    }

    public Image getCurrentGraphics() {
        Animation graphics = this.stateMachine.getActiveStateProperties();
        return graphics.getFrameAtTime(this.stateMachine.getActiveStateTime());
    }

    public int getCurrentWidth() {
        return this.getCurrentGraphics().getWidth();
    }

    public int getCurrentHeight() {
        return this.getCurrentGraphics().getHeight();
    }

    @Override
    public Rect getStageBounds() {
        Transform globalTransform = this.getGlobalTransform();
        Point2D position = globalTransform.getPosition();
        float width = Math.max((float)this.getCurrentWidth() * (globalTransform.getScaleX() / 100.0f), 1.0f);
        float height = Math.max((float)this.getCurrentHeight() * (globalTransform.getScaleY() / 100.0f), 1.0f);
        return new Rect(position.getX() - width / 2.0f, position.getY() - height / 2.0f, width, height);
    }

    public Sprite copy() {
        Sprite copy = new Sprite();
        for (State<Animation> state : this.stateMachine.getPossibleStates()) {
            copy.addState(state.name(), state.properties());
        }
        copy.changeState(this.stateMachine.getActiveState().name());
        copy.getTransform().set(this.getTransform());
        return copy;
    }

    public String toString() {
        return "Sprite [" + this.getCurrentGraphics() + "]";
    }

    @Override
    public StageLocation getLocation() {
        return this.location;
    }
}

