/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.stage;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import nl.colorize.multimedialib.math.Point2D;
import nl.colorize.multimedialib.math.Rect;
import nl.colorize.multimedialib.stage.Align;
import nl.colorize.multimedialib.stage.Graphic2D;
import nl.colorize.multimedialib.stage.OutlineFont;
import nl.colorize.multimedialib.stage.StageLocation;
import nl.colorize.multimedialib.stage.Transform;
import nl.colorize.util.TextUtils;

public class Text
implements Graphic2D {
    private final StageLocation location = new StageLocation();
    private String text;
    private List<String> lines;
    private OutlineFont font;
    private Align align;
    private float lineHeight;

    public Text(String text, OutlineFont font, Align align) {
        this.text = text;
        this.lines = TextUtils.LINE_SPLITTER.splitToList((CharSequence)text);
        this.font = font;
        this.align = align;
        this.lineHeight = font == null ? 10.0f : (float)Math.round((float)font.getStyle().size() * 1.8f);
    }

    public Text(String text, OutlineFont font) {
        this(text, font, Align.LEFT);
    }

    public void setText(String ... lines) {
        this.setText((List<String>)ImmutableList.copyOf((Object[])lines));
    }

    public void setText(List<String> lines) {
        if (lines.isEmpty()) {
            this.text = "";
            this.lines = Collections.emptyList();
        } else if (lines.size() == 1) {
            this.text = lines.get(0);
            this.lines = TextUtils.LINE_SPLITTER.splitToList((CharSequence)this.text);
        } else {
            this.text = TextUtils.LINE_JOINER.join(lines);
            this.lines = lines;
        }
    }

    public void forLines(BiConsumer<Integer, String> callback) {
        for (int i = 0; i < this.lines.size(); ++i) {
            callback.accept(i, this.lines.get(i));
        }
    }

    @Override
    public void update(float deltaTime) {
    }

    @Override
    public Rect getStageBounds() {
        Transform globalTransform = this.getGlobalTransform();
        Point2D position = globalTransform.getPosition();
        float approximateWidth = this.font.getStyle().size() * this.text.length();
        float approximateHeight = this.lineHeight * (float)this.lines.size();
        return new Rect(position.getX(), position.getY(), approximateWidth, approximateHeight);
    }

    public String toString() {
        Object displayText = this.text.replace("\n", " ");
        if (((String)displayText).length() > 20) {
            displayText = ((String)displayText).substring(0, 20) + "...";
        }
        return "Text [" + (String)displayText + "]";
    }

    @Override
    public StageLocation getLocation() {
        return this.location;
    }

    public String getText() {
        return this.text;
    }

    public List<String> getLines() {
        return this.lines;
    }

    public OutlineFont getFont() {
        return this.font;
    }

    public Align getAlign() {
        return this.align;
    }

    public float getLineHeight() {
        return this.lineHeight;
    }

    public void setLines(List<String> lines) {
        this.lines = lines;
    }

    public void setFont(OutlineFont font) {
        this.font = font;
    }

    public void setAlign(Align align) {
        this.align = align;
    }

    public void setLineHeight(float lineHeight) {
        this.lineHeight = lineHeight;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Text)) {
            return false;
        }
        Text other = (Text)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getLineHeight(), other.getLineHeight()) != 0) {
            return false;
        }
        StageLocation this$location = this.getLocation();
        StageLocation other$location = other.getLocation();
        if (this$location == null ? other$location != null : !this$location.equals(other$location)) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
            return false;
        }
        List<String> this$lines = this.getLines();
        List<String> other$lines = other.getLines();
        if (this$lines == null ? other$lines != null : !((Object)this$lines).equals(other$lines)) {
            return false;
        }
        OutlineFont this$font = this.getFont();
        OutlineFont other$font = other.getFont();
        if (this$font == null ? other$font != null : !this$font.equals(other$font)) {
            return false;
        }
        Align this$align = this.getAlign();
        Align other$align = other.getAlign();
        return !(this$align == null ? other$align != null : !((Object)((Object)this$align)).equals((Object)other$align));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Text;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getLineHeight());
        StageLocation $location = this.getLocation();
        result = result * 59 + ($location == null ? 43 : $location.hashCode());
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        List<String> $lines = this.getLines();
        result = result * 59 + ($lines == null ? 43 : ((Object)$lines).hashCode());
        OutlineFont $font = this.getFont();
        result = result * 59 + ($font == null ? 43 : $font.hashCode());
        Align $align = this.getAlign();
        result = result * 59 + ($align == null ? 43 : ((Object)((Object)$align)).hashCode());
        return result;
    }
}

