/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.stage;

import java.util.ArrayList;
import java.util.List;
import nl.colorize.multimedialib.math.Point3D;
import nl.colorize.multimedialib.scene.Updatable;
import nl.colorize.multimedialib.stage.ColorRGB;
import nl.colorize.multimedialib.stage.PolygonModel;

public class World3D
implements Updatable {
    private Point3D cameraPosition = new Point3D(10.0f, 10.0f, 10.0f);
    private Point3D cameraTarget = new Point3D(0.0f, 0.0f, 0.0f);
    private ColorRGB ambientLight = new ColorRGB(100, 100, 100);
    private ColorRGB lightColor = new ColorRGB(200, 200, 200);
    private Point3D lightPosition = new Point3D(-1.0f, -0.8f, -0.2f);
    private final List<PolygonModel> children = new ArrayList<PolygonModel>();

    protected World3D() {
    }

    @Override
    public void update(float deltaTime) {
        for (PolygonModel model : this.children) {
            model.update(deltaTime);
        }
    }

    public String toString() {
        return "World3D";
    }

    public Point3D getCameraPosition() {
        return this.cameraPosition;
    }

    public Point3D getCameraTarget() {
        return this.cameraTarget;
    }

    public ColorRGB getAmbientLight() {
        return this.ambientLight;
    }

    public ColorRGB getLightColor() {
        return this.lightColor;
    }

    public Point3D getLightPosition() {
        return this.lightPosition;
    }

    public List<PolygonModel> getChildren() {
        return this.children;
    }

    public void setCameraPosition(Point3D cameraPosition) {
        this.cameraPosition = cameraPosition;
    }

    public void setCameraTarget(Point3D cameraTarget) {
        this.cameraTarget = cameraTarget;
    }

    public void setAmbientLight(ColorRGB ambientLight) {
        this.ambientLight = ambientLight;
    }

    public void setLightColor(ColorRGB lightColor) {
        this.lightColor = lightColor;
    }

    public void setLightPosition(Point3D lightPosition) {
        this.lightPosition = lightPosition;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof World3D)) {
            return false;
        }
        World3D other = (World3D)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Point3D this$cameraPosition = this.getCameraPosition();
        Point3D other$cameraPosition = other.getCameraPosition();
        if (this$cameraPosition == null ? other$cameraPosition != null : !((Object)this$cameraPosition).equals(other$cameraPosition)) {
            return false;
        }
        Point3D this$cameraTarget = this.getCameraTarget();
        Point3D other$cameraTarget = other.getCameraTarget();
        if (this$cameraTarget == null ? other$cameraTarget != null : !((Object)this$cameraTarget).equals(other$cameraTarget)) {
            return false;
        }
        ColorRGB this$ambientLight = this.getAmbientLight();
        ColorRGB other$ambientLight = other.getAmbientLight();
        if (this$ambientLight == null ? other$ambientLight != null : !((Object)this$ambientLight).equals(other$ambientLight)) {
            return false;
        }
        ColorRGB this$lightColor = this.getLightColor();
        ColorRGB other$lightColor = other.getLightColor();
        if (this$lightColor == null ? other$lightColor != null : !((Object)this$lightColor).equals(other$lightColor)) {
            return false;
        }
        Point3D this$lightPosition = this.getLightPosition();
        Point3D other$lightPosition = other.getLightPosition();
        if (this$lightPosition == null ? other$lightPosition != null : !((Object)this$lightPosition).equals(other$lightPosition)) {
            return false;
        }
        List<PolygonModel> this$children = this.getChildren();
        List<PolygonModel> other$children = other.getChildren();
        return !(this$children == null ? other$children != null : !((Object)this$children).equals(other$children));
    }

    protected boolean canEqual(Object other) {
        return other instanceof World3D;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Point3D $cameraPosition = this.getCameraPosition();
        result = result * 59 + ($cameraPosition == null ? 43 : ((Object)$cameraPosition).hashCode());
        Point3D $cameraTarget = this.getCameraTarget();
        result = result * 59 + ($cameraTarget == null ? 43 : ((Object)$cameraTarget).hashCode());
        ColorRGB $ambientLight = this.getAmbientLight();
        result = result * 59 + ($ambientLight == null ? 43 : ((Object)$ambientLight).hashCode());
        ColorRGB $lightColor = this.getLightColor();
        result = result * 59 + ($lightColor == null ? 43 : ((Object)$lightColor).hashCode());
        Point3D $lightPosition = this.getLightPosition();
        result = result * 59 + ($lightPosition == null ? 43 : ((Object)$lightPosition).hashCode());
        List<PolygonModel> $children = this.getChildren();
        result = result * 59 + ($children == null ? 43 : ((Object)$children).hashCode());
        return result;
    }
}

