/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.math;

public final class Point3D {
    private final float x;
    private final float y;
    private final float z;

    public Point3D(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Point3D normalize() {
        float length = (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        return new Point3D(this.x / length, this.y / length, this.z / length);
    }

    public String toString() {
        return String.format("(%d, %d, %d)", Math.round(this.x), Math.round(this.y), Math.round(this.z));
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getZ() {
        return this.z;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Point3D)) {
            return false;
        }
        Point3D other = (Point3D)o;
        if (Float.compare(this.getX(), other.getX()) != 0) {
            return false;
        }
        if (Float.compare(this.getY(), other.getY()) != 0) {
            return false;
        }
        return Float.compare(this.getZ(), other.getZ()) == 0;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getX());
        result = result * 59 + Float.floatToIntBits(this.getY());
        result = result * 59 + Float.floatToIntBits(this.getZ());
        return result;
    }
}

