/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.math;

import com.google.common.base.Preconditions;
import nl.colorize.multimedialib.math.Point2D;
import nl.colorize.multimedialib.math.Polygon;
import nl.colorize.multimedialib.math.Shape;

public final class Rect
implements Shape {
    private final float x;
    private final float y;
    private final float width;
    private final float height;

    public Rect(float x, float y, float width, float height) {
        Preconditions.checkArgument((width >= 0.0f ? 1 : 0) != 0, (Object)("Invalid width: " + width));
        Preconditions.checkArgument((height >= 0.0f ? 1 : 0) != 0, (Object)("Invalid height: " + height));
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public float getEndX() {
        return this.x + this.width;
    }

    public float getEndY() {
        return this.y + this.height;
    }

    public float getCenterX() {
        return this.x + this.width / 2.0f;
    }

    public float getCenterY() {
        return this.y + this.height / 2.0f;
    }

    public Point2D getCenter() {
        return new Point2D(this.getCenterX(), this.getCenterY());
    }

    @Override
    public boolean contains(Point2D p) {
        return this.contains(p.getX(), p.getY());
    }

    public boolean contains(float px, float py) {
        return px >= this.x && px <= this.x + this.width && py >= this.y && py <= this.y + this.height;
    }

    public boolean contains(Rect r) {
        return r.x >= this.x && r.x + r.width <= this.x + this.width && r.y >= this.y && r.y + r.height <= this.y + this.height;
    }

    public boolean intersects(Rect r) {
        return !(r.x + r.width < this.x || r.x > this.x + this.width || r.y + r.height < this.y || r.y > this.y + this.height);
    }

    @Override
    public Rect getBoundingBox() {
        return this;
    }

    @Override
    public Rect reposition(Point2D offset) {
        return new Rect(this.x + offset.getX(), this.y + offset.getY(), this.width, this.height);
    }

    public Polygon toPolygon() {
        return new Polygon(this.x, this.y, this.x + this.width, this.y, this.x + this.width, this.y + this.height, this.x, this.y + this.height);
    }

    public String toString() {
        return String.format("(%d, %d, %d, %d)", Math.round(this.x), Math.round(this.y), Math.round(this.width), Math.round(this.height));
    }

    public static Rect fromPoints(float x0, float y0, float x1, float y1) {
        return new Rect(x0, y0, x1 - x0, y1 - y0);
    }

    public static Rect around(float x, float y, float width, float height) {
        return Rect.around(new Point2D(x, y), width, height);
    }

    public static Rect around(Point2D center, float width, float height) {
        return new Rect(center.getX() - width / 2.0f, center.getY() - height / 2.0f, width, height);
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Rect)) {
            return false;
        }
        Rect other = (Rect)o;
        if (Float.compare(this.getX(), other.getX()) != 0) {
            return false;
        }
        if (Float.compare(this.getY(), other.getY()) != 0) {
            return false;
        }
        if (Float.compare(this.getWidth(), other.getWidth()) != 0) {
            return false;
        }
        return Float.compare(this.getHeight(), other.getHeight()) == 0;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getX());
        result = result * 59 + Float.floatToIntBits(this.getY());
        result = result * 59 + Float.floatToIntBits(this.getWidth());
        result = result * 59 + Float.floatToIntBits(this.getHeight());
        return result;
    }
}

