/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.teavm;

import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.logging.Logger;
import nl.colorize.multimedialib.renderer.Network;
import nl.colorize.multimedialib.renderer.teavm.BrowserDOM;
import nl.colorize.util.LogHelper;
import nl.colorize.util.Promise;
import nl.colorize.util.http.Headers;
import nl.colorize.util.http.PostData;
import nl.colorize.util.http.URLResponse;
import org.teavm.jso.ajax.XMLHttpRequest;

public class TeaNetwork
implements Network {
    private static final Splitter HEADER_SPLITTER = Splitter.on((CharMatcher)CharMatcher.anyOf((CharSequence)"\r\n"));
    private static final Logger LOGGER = LogHelper.getLogger(TeaNetwork.class);

    @Override
    public Promise<URLResponse> get(String url, Headers headers) {
        XMLHttpRequest request = XMLHttpRequest.create();
        Promise promise = new Promise();
        request.setOnReadyStateChange(() -> this.handleResponse(request, (Promise<URLResponse>)promise));
        request.open("GET", url, true);
        this.addRequestHeaders(request, headers);
        request.send();
        return promise;
    }

    @Override
    public Promise<URLResponse> post(String url, Headers headers, PostData data) {
        XMLHttpRequest request = XMLHttpRequest.create();
        Promise promise = new Promise();
        request.setOnReadyStateChange(() -> this.handleResponse(request, (Promise<URLResponse>)promise));
        request.open("POST", url, true);
        this.addRequestHeaders(request, headers);
        request.send(data.encode(StandardCharsets.UTF_8));
        return promise;
    }

    private void addRequestHeaders(XMLHttpRequest request, Headers headers) {
        request.setRequestHeader("X-Requested-With", "MultimediaLib");
        if (headers != null) {
            headers.forEach((arg_0, arg_1) -> ((XMLHttpRequest)request).setRequestHeader(arg_0, arg_1));
        }
    }

    private void handleResponse(XMLHttpRequest request, Promise<URLResponse> promise) {
        if (request.getReadyState() == 4) {
            if (request.getStatus() >= 200 && request.getStatus() <= 204) {
                URLResponse response = this.parseResponse(request);
                promise.resolve((Object)response);
            } else {
                promise.reject((Exception)new IOException("AJAX request failed: " + request.getStatusText()));
            }
        }
    }

    private URLResponse parseResponse(XMLHttpRequest request) {
        int status = request.getStatus();
        Headers headers = this.parseResponseHeaders(request);
        String body = request.getResponseText();
        return new URLResponse(status, headers, body.getBytes(StandardCharsets.UTF_8), StandardCharsets.UTF_8, Collections.emptyMap());
    }

    private Headers parseResponseHeaders(XMLHttpRequest request) {
        Headers headers = new Headers();
        for (String line : HEADER_SPLITTER.split((CharSequence)request.getAllResponseHeaders())) {
            if (line.contains(": ")) {
                String name = line.substring(0, line.indexOf(": "));
                String value = line.substring(line.indexOf(": ") + 2);
                headers = headers.concat(name, value);
                continue;
            }
            if (line.isEmpty()) continue;
            LOGGER.warning("Malformed HTTP response header: " + line);
        }
        return headers;
    }

    @Override
    public boolean isDevelopmentEnvironment() {
        return BrowserDOM.getQueryString().contains("local");
    }
}

