/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.teavm;

import com.google.common.base.Preconditions;
import nl.colorize.multimedialib.math.Circle;
import nl.colorize.multimedialib.math.Line;
import nl.colorize.multimedialib.math.Polygon;
import nl.colorize.multimedialib.math.Rect;
import nl.colorize.multimedialib.math.Region;
import nl.colorize.multimedialib.math.SegmentedLine;
import nl.colorize.multimedialib.renderer.Canvas;
import nl.colorize.multimedialib.renderer.GraphicsMode;
import nl.colorize.multimedialib.renderer.teavm.BrowserDOM;
import nl.colorize.multimedialib.renderer.teavm.TeaGraphics;
import nl.colorize.multimedialib.renderer.teavm.TeaImage;
import nl.colorize.multimedialib.stage.ColorRGB;
import nl.colorize.multimedialib.stage.Container;
import nl.colorize.multimedialib.stage.Graphic2D;
import nl.colorize.multimedialib.stage.Primitive;
import nl.colorize.multimedialib.stage.Sprite;
import nl.colorize.multimedialib.stage.Stage;
import nl.colorize.multimedialib.stage.Text;
import nl.colorize.multimedialib.stage.Transform;
import nl.colorize.util.stats.Cache;
import org.teavm.jso.browser.Window;
import org.teavm.jso.dom.html.HTMLCanvasElement;
import org.teavm.jso.dom.html.HTMLDocument;
import org.teavm.jso.dom.html.HTMLElement;
import org.teavm.jso.dom.html.HTMLImageElement;
import org.teavm.jso.typedarrays.ArrayBufferView;
import org.teavm.jso.typedarrays.Float32Array;
import org.teavm.jso.webgl.WebGLBuffer;
import org.teavm.jso.webgl.WebGLProgram;
import org.teavm.jso.webgl.WebGLRenderingContext;
import org.teavm.jso.webgl.WebGLShader;
import org.teavm.jso.webgl.WebGLTexture;
import org.teavm.jso.webgl.WebGLUniformLocation;

public class WebGL
implements TeaGraphics {
    private Canvas canvas;
    private BrowserDOM dom;
    private HTMLCanvasElement htmlCanvas;
    private WebGLRenderingContext gl;
    private WebGLProgram shaderProgram;
    private int aVertexPosition;
    private int aTextureCoordinates;
    private WebGLUniformLocation uRotationVector;
    private WebGLUniformLocation uScaleVector;
    private WebGLUniformLocation uTexture;
    private Cache<TeaImage, MeshData> meshes;
    private Cache<TeaImage, WebGLTexture> textures;
    private static final String VERTEX_SHADER = "attribute vec2 aVertexPosition;\nattribute vec2 aTextureCoordinates;\nuniform vec2 uRotationVector;\nuniform vec2 uScaleVector;\nvarying vec2 vTextureCoordinates;\n\nvoid main() {\n    vec2 rotatedPosition = vec2(\n        aVertexPosition.x * uRotationVector.y + aVertexPosition.y * uRotationVector.x,\n        aVertexPosition.y * uRotationVector.y - aVertexPosition.x * uRotationVector.x\n    );\n\n    gl_Position = vec4(rotatedPosition * uScaleVector, 0.0, 1.0);\n    vTextureCoordinates = aTextureCoordinates;\n}\n";
    private static final String FRAGMENT_SHADER = "precision mediump float;\nvarying vec2 vTextureCoordinates;\nuniform sampler2D uTexture;\n\nvoid main() {\n    gl_FragColor = texture2D(uTexture, vTextureCoordinates);\n    gl_FragColor.rgb *= gl_FragColor.a;\n    //gl_FragColor = vec4(1.0, 0.0, 0.0, 1.0);\n}\n";

    public WebGL(Canvas canvas) {
        this.canvas = canvas;
        this.dom = new BrowserDOM();
    }

    @Override
    public GraphicsMode getGraphicsMode() {
        return GraphicsMode.MODE_2D;
    }

    @Override
    public int getDisplayWidth() {
        return this.htmlCanvas.getWidth();
    }

    @Override
    public int getDisplayHeight() {
        return this.htmlCanvas.getHeight();
    }

    @Override
    public void init() {
        HTMLDocument document = Window.current().getDocument();
        HTMLElement container = document.getElementById("multimediaLibContainer");
        this.htmlCanvas = this.dom.createCanvas(container);
        this.gl = (WebGLRenderingContext)this.htmlCanvas.getContext("webgl");
        this.initShaderProgram();
        this.meshes = Cache.from(this::createImageMeshData);
        this.textures = Cache.from(this::loadTexture);
    }

    private void initShaderProgram() {
        this.shaderProgram = this.gl.createProgram();
        this.compileShader(35633, VERTEX_SHADER);
        this.compileShader(35632, FRAGMENT_SHADER);
        this.gl.linkProgram(this.shaderProgram);
        if (this.gl.getProgramParameter(this.shaderProgram, 35714) == null) {
            throw new RuntimeException("Shader link error: " + this.gl.getProgramInfoLog(this.shaderProgram));
        }
        this.aVertexPosition = this.gl.getAttribLocation(this.shaderProgram, "aVertexPosition");
        this.aTextureCoordinates = this.gl.getAttribLocation(this.shaderProgram, "aTextureCoordinates");
        this.uRotationVector = this.gl.getUniformLocation(this.shaderProgram, "uRotationVector");
        this.uScaleVector = this.gl.getUniformLocation(this.shaderProgram, "uScaleVector");
        this.uTexture = this.gl.getUniformLocation(this.shaderProgram, "uTexture");
    }

    private void compileShader(int shaderType, String glsl) {
        WebGLShader shader = this.gl.createShader(shaderType);
        this.gl.shaderSource(shader, glsl);
        this.gl.compileShader(shader);
        if (this.gl.getShaderParameter(shader, 35713) == null) {
            this.gl.deleteShader(shader);
            throw new RuntimeException("Shader compile error: " + this.gl.getShaderInfoLog(shader));
        }
        this.gl.attachShader(this.shaderProgram, shader);
    }

    private MeshData createImageMeshData(TeaImage image) {
        WebGLBuffer vertexBuffer = this.gl.createBuffer();
        this.bufferData(vertexBuffer, -0.5f, -0.5f, 0.5f, 0.5f);
        WebGLBuffer textureBuffer = this.gl.createBuffer();
        this.bufferData(textureBuffer, 0.0f, 0.0f, 1.0f, 1.0f);
        float[] rotation = new float[]{(float)Math.sin(0.0), (float)Math.cos(0.0)};
        float[] scale = new float[]{1.0f, 1.0f};
        WebGLTexture texture = (WebGLTexture)this.textures.get((Object)image.forParentImage());
        return new MeshData(vertexBuffer, textureBuffer, rotation, scale, texture);
    }

    private WebGLTexture loadTexture(TeaImage image) {
        Preconditions.checkState((boolean)image.isLoaded(), (Object)"Image is still loading");
        Preconditions.checkState((boolean)image.isFullImage(), (Object)"Cannot create texture from image region");
        HTMLImageElement imageElement = image.getImageElement().get();
        WebGLTexture texture = this.gl.createTexture();
        this.gl.bindTexture(3553, texture);
        this.gl.texImage2D(3553, 0, 6408, 6408, 5121, imageElement);
        this.gl.texParameteri(3553, 10242, 33071);
        this.gl.texParameteri(3553, 10243, 33071);
        this.gl.texParameteri(3553, 10241, 9729);
        this.gl.pixelStorei(37440, 1);
        return texture;
    }

    private void bufferData(WebGLBuffer buffer, float x0, float y0, float x1, float y1) {
        float[] data = new float[]{x0, y0, x1, y0, x0, y1, x0, y1, x1, y0, x1, y1};
        Float32Array wrapper = Float32Array.create((int)12);
        wrapper.set(data);
        this.gl.bindBuffer(34962, buffer);
        this.gl.bufferData(34962, (ArrayBufferView)wrapper, 35044);
    }

    private void drawMesh(MeshData meshData) {
        this.gl.bindTexture(3553, meshData.texture);
        this.gl.uniform2fv(this.uRotationVector, meshData.rotation);
        this.gl.uniform2fv(this.uScaleVector, meshData.scale);
        this.gl.bindBuffer(34962, meshData.vertexBuffer);
        this.gl.enableVertexAttribArray(this.aVertexPosition);
        this.gl.vertexAttribPointer(this.aVertexPosition, 2, 5126, false, 0, 0);
        this.gl.bindBuffer(34962, meshData.textureBuffer);
        this.gl.enableVertexAttribArray(this.aTextureCoordinates);
        this.gl.vertexAttribPointer(this.aTextureCoordinates, 2, 5126, false, 0, 0);
        this.gl.drawArrays(4, 0, 6);
    }

    @Override
    public void prepareStage(Stage stage) {
        this.gl.viewport(0, 0, this.gl.getCanvas().getWidth(), this.gl.getCanvas().getHeight());
        this.gl.enable(3042);
        this.gl.blendFunc(1, 771);
        this.gl.useProgram(this.shaderProgram);
    }

    @Override
    public void onGraphicAdded(Container parent, Graphic2D graphic) {
    }

    @Override
    public void onGraphicRemoved(Container parent, Graphic2D graphic) {
    }

    @Override
    public boolean visitGraphic(Graphic2D graphic) {
        return true;
    }

    @Override
    public void drawBackground(ColorRGB color) {
        this.gl.clearColor((float)color.r() / 255.0f, (float)color.g() / 255.0f, (float)color.b() / 255.0f, 1.0f);
        this.gl.clear(16384);
    }

    @Override
    public void drawSprite(Sprite sprite) {
        TeaImage image = (TeaImage)sprite.getCurrentGraphics();
        HTMLImageElement imageElement = image.getImagePromise().getValue().orElse(null);
        if (imageElement == null) {
            return;
        }
        MeshData meshData = (MeshData)this.meshes.get((Object)image);
        Region region = image.getRegion();
        Transform transform = sprite.getGlobalTransform();
        this.bufferData(meshData.vertexBuffer, this.toGLX(transform.getPosition().getX() - (float)image.getWidth() / 2.0f), this.toGLY(transform.getPosition().getY() - (float)image.getHeight() / 2.0f), this.toGLX(transform.getPosition().getX() + (float)image.getWidth() / 2.0f), this.toGLY(transform.getPosition().getY() + (float)image.getHeight() / 2.0f));
        this.bufferData(meshData.textureBuffer, (float)region.x() / (float)imageElement.getWidth(), 1.0f - (float)region.y1() / (float)imageElement.getHeight(), (float)region.x1() / (float)imageElement.getWidth(), 1.0f - (float)region.y() / (float)imageElement.getHeight());
        this.drawMesh(meshData);
    }

    @Override
    public void drawLine(Primitive graphic, Line line) {
    }

    @Override
    public void drawSegmentedLine(Primitive graphic, SegmentedLine line) {
    }

    @Override
    public void drawRect(Primitive graphic, Rect rect) {
    }

    @Override
    public void drawCircle(Primitive graphic, Circle circle) {
    }

    @Override
    public void drawPolygon(Primitive graphic, Polygon polygon) {
    }

    @Override
    public void drawText(Text text) {
    }

    protected float toGLX(float canvasX) {
        return canvasX / (float)this.canvas.getWidth() * 2.0f - 1.0f;
    }

    protected float toGLY(float canvasY) {
        return canvasY / (float)this.canvas.getHeight() * 2.0f - 1.0f;
    }

    private record MeshData(WebGLBuffer vertexBuffer, WebGLBuffer textureBuffer, float[] rotation, float[] scale, WebGLTexture texture) {
        public MeshData {
            Preconditions.checkArgument((rotation.length == 2 ? 1 : 0) != 0, (Object)"Invalid rotation buffer");
            Preconditions.checkArgument((scale.length == 2 ? 1 : 0) != 0, (Object)"Invalid scale buffer");
        }
    }
}

