/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.scene;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import nl.colorize.multimedialib.scene.State;
import nl.colorize.multimedialib.scene.Updatable;

public class FiniteStateMachine<T>
implements Updatable {
    private Map<String, State<T>> possibleStates = new HashMap<String, State<T>>();
    private State<T> activeState = null;
    private float activeStateTime = 0.0f;

    public void register(State<T> state) {
        Preconditions.checkArgument((!this.possibleStates.containsKey(state.name()) ? 1 : 0) != 0, (Object)("Finite state machine already contains state: " + state.name()));
        this.possibleStates.put(state.name(), state);
        if (this.possibleStates.size() == 1) {
            this.changeState(state);
        }
    }

    public void changeState(State<T> requestedState) {
        Preconditions.checkArgument((requestedState != null ? 1 : 0) != 0, (Object)"Cannot use null state");
        if (this.activeState != null && requestedState.name().equals(this.activeState.name())) {
            return;
        }
        this.activeState = requestedState;
        this.activeStateTime = 0.0f;
    }

    public void changeState(String requestedStateName) {
        State<T> requestedState = this.possibleStates.get(requestedStateName);
        Preconditions.checkArgument((requestedState != null ? 1 : 0) != 0, (Object)("Not a possible state: " + requestedStateName));
        this.changeState(requestedState);
    }

    @Override
    public void update(float deltaTime) {
        this.checkActiveState();
        this.activeStateTime += deltaTime;
        if (this.activeState.duration() > 0.0f && this.activeStateTime >= this.activeState.duration()) {
            this.changeState(this.activeState.nextState());
        }
    }

    private void checkActiveState() {
        Preconditions.checkState((this.activeState != null ? 1 : 0) != 0, (Object)"Finite state machine is not in an active state");
    }

    public void resetActiveState() {
        this.activeStateTime = 0.0f;
    }

    public State<T> getActiveState() {
        this.checkActiveState();
        return this.activeState;
    }

    public String getActiveStateName() {
        return this.getActiveState().name();
    }

    public T getActiveStateProperties() {
        return this.getActiveState().properties();
    }

    public float getActiveStateTime() {
        return this.activeStateTime;
    }

    public Set<State<T>> getPossibleStates() {
        return ImmutableSet.copyOf(this.possibleStates.values());
    }

    public State<T> getPossibleState(String name) {
        State<T> state = this.possibleStates.get(name);
        Preconditions.checkArgument((state != null ? 1 : 0) != 0, (Object)("Not a possible state: " + state));
        return state;
    }

    public boolean hasPossibleState(String name) {
        return this.possibleStates.containsKey(name);
    }
}

