/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.scene;

import com.google.common.base.Preconditions;

public record State<T>(String name, float duration, State<T> nextState, T properties) {
    public State {
        Preconditions.checkArgument((!name.isEmpty() ? 1 : 0) != 0, (Object)"Missing state name");
        Preconditions.checkArgument((duration >= 0.0f ? 1 : 0) != 0, (Object)("Invalid duration: " + duration));
        Preconditions.checkArgument((duration > 0.0f == (nextState != null) ? 1 : 0) != 0, (Object)"Cannot define next state for state with infinite duration");
    }

    public static <T> State<T> of(String name, float duration, State<T> nextState, T properties) {
        return new State<T>(name, duration, nextState, properties);
    }

    public static <T> State<T> of(String name, T properties) {
        return new State<T>(name, 0.0f, null, properties);
    }
}

