/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.tool;

import com.badlogic.gdx.tools.texturepacker.TexturePacker;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import nl.colorize.util.FileUtils;
import nl.colorize.util.LogHelper;
import nl.colorize.util.cli.Arg;
import nl.colorize.util.cli.CommandLineArgumentParser;

public class SpriteAtlasPacker {
    @Arg(name="input")
    protected File inputDir;
    @Arg(name="output")
    protected File outputDir;
    @Arg(required=false, usage="File name for generated sprite atlas, defaults to directory name")
    protected String atlasName;
    @Arg(usage="Creates a separate sprite atlas for each subdirectory")
    protected boolean nested;
    @Arg(usage="Base region name on file name only instead of relative path")
    protected boolean flatten;
    private static final List<String> IMAGE_FILE_EXTENSIONS = List.of("png", "jpg");
    private static final Logger LOGGER = LogHelper.getLogger(SpriteAtlasPacker.class);

    public static void main(String[] argv) {
        CommandLineArgumentParser argParser = new CommandLineArgumentParser(SpriteAtlasPacker.class);
        SpriteAtlasPacker spriteAtlasPacker = (SpriteAtlasPacker)argParser.parse(argv, SpriteAtlasPacker.class);
        spriteAtlasPacker.run();
    }

    protected void run() {
        TexturePacker.Settings settings = new TexturePacker.Settings();
        settings.flattenPaths = this.flatten;
        for (File imageDir : this.locateImageDirs()) {
            LOGGER.info("Gathering images from " + imageDir.getAbsolutePath());
            TexturePacker.process((TexturePacker.Settings)settings, (String)imageDir.getAbsolutePath(), (String)this.outputDir.getAbsolutePath(), (String)this.getAtlasName(imageDir));
            LOGGER.info("Generated sprite atlas in " + this.outputDir.getAbsolutePath());
        }
    }

    private List<File> locateImageDirs() {
        if (!this.nested) {
            return List.of(this.inputDir);
        }
        try {
            return Files.walk(this.inputDir.toPath(), new FileVisitOption[0]).map(path -> path.toFile()).filter(File::isDirectory).filter(this::containsImages).toList();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot read directory", e);
        }
    }

    private boolean containsImages(File dir) {
        return Arrays.stream(dir.listFiles()).filter(file -> !file.isDirectory()).map(FileUtils::getFileExtension).anyMatch(IMAGE_FILE_EXTENSIONS::contains);
    }

    private String getAtlasName(File imageDir) {
        if (this.atlasName == null || this.atlasName.isEmpty()) {
            return imageDir.getName();
        }
        Preconditions.checkArgument((!this.nested ? 1 : 0) != 0, (Object)"Cannot combine --nested with --name");
        return this.atlasName;
    }
}

