//-----------------------------------------------------------------------------
// Colorize MultimediaLib
// Copyright 2009-2023 Colorize
// Apache license (http://www.apache.org/licenses/LICENSE-2.0)
//-----------------------------------------------------------------------------

package nl.colorize.multimedialib.renderer;

import java.util.List;

/**
 * Enumerates the keys on a conventional keyboard.
 */
public enum KeyCode {
    LEFT,
    RIGHT,
    UP,
    DOWN,

    ENTER,
    SPACEBAR,
    ESCAPE,
    SHIFT,
    BACKSPACE,
    TAB,

    A,
    B,
    C,
    D,
    E,
    F,
    G,
    H,
    I,
    J,
    K,
    L,
    M,
    N,
    O,
    P,
    Q,
    R,
    S,
    T,
    U,
    V,
    W,
    X,
    Y,
    Z,

    N1,
    N2,
    N3,
    N4,
    N5,
    N6,
    N7,
    N8,
    N9,
    N0,

    F1,
    F2,
    F3,
    F4,
    F5,
    F6,
    F7,
    F8,
    F9,
    F10,
    F11,
    F12;

    public static final List<KeyCode> ARROWS = List.of(LEFT, RIGHT, UP, DOWN);
}
