//-----------------------------------------------------------------------------
// Colorize MultimediaLib
// Copyright 2009-2023 Colorize
// Apache license (http://www.apache.org/licenses/LICENSE-2.0)
//-----------------------------------------------------------------------------

package nl.colorize.multimedialib.renderer.teavm;

import nl.colorize.multimedialib.renderer.pixi.PixiInterface;
import nl.colorize.multimedialib.renderer.three.ThreeInterface;
import org.teavm.jso.JSBody;

/**
 * Contains the API for calling JavaScript functions using TeaVM. This consists
 * of general browser APIs and bindings to the parts of MultimediaLib that are
 * implemented in JavaScript. This class therefore acts as the bridge between
 * the TeaVM renderer implementation in Java code, and the "native" browser
 * code implemented in JavaScript.
 */
public class Browser {

    @JSBody(
        params = {"message"},
        script = "console.log(message);"
    )
    public static native void log(String message);

    @JSBody(script = "return navigator.userAgent;")
    public static native String getUserAgent();

    @JSBody(script = "return document.documentElement.clientWidth;")
    public static native float getPageWidth();

    @JSBody(script = "return document.documentElement.clientHeight;")
    public static native float getPageHeight();

    @JSBody(script = "return window.screen.width;")
    public static native int getScreenWidth();

    @JSBody(script = "return window.screen.height;")
    public static native int getScreenHeight();

    @JSBody(script = "return (\"ontouchstart\" in window) || navigator.maxTouchPoints > 0")
    public static native boolean isTouchSupported();

    @JSBody(script = "window.prepareAnimationLoop();")
    public static native void prepareAnimationLoop();

    @JSBody(
        params = {"callback"},
        script = "window.registerErrorHandler(callback);"
    )
    public static native void registerErrorHandler(ErrorCallback callback);

    @JSBody(
        params = {"family", "url", "callback"},
        script = "return window.preloadFontFace(family, url, callback);"
    )
    public static native void preloadFontFace(String family, String url, FontLoadCallback callback);

    // ----------------------------------------
    // JavaScript framework interfaces
    // ----------------------------------------

    @JSBody(script = "return window.pixiInterface;")
    public static native PixiInterface getPixiInterface();

    @JSBody(script = "return window.threeInterface;")
    public static native ThreeInterface getThreeInterface();
}
