/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.demo;

import nl.colorize.multimedialib.demo.Demo2D;
import nl.colorize.multimedialib.renderer.Canvas;
import nl.colorize.multimedialib.renderer.DisplayMode;
import nl.colorize.multimedialib.renderer.ScaleStrategy;
import nl.colorize.multimedialib.renderer.teavm.Browser;
import nl.colorize.multimedialib.renderer.teavm.BrowserDOM;
import nl.colorize.multimedialib.renderer.teavm.TeaRenderer;
import nl.colorize.multimedialib.scene.SceneContext;
import nl.colorize.util.http.PostData;

public class TeaDemo2D {
    private static final int BROWSER_FRAMERATE = 60;

    public static void main(String[] args) {
        Browser.log("MultimediaLib - TeaVM Demo");
        Browser.log("Screen size: " + Browser.getScreenWidth() + "x" + Browser.getScreenHeight());
        Browser.log("Page size: " + Math.round(Browser.getPageWidth()) + "x" + Math.round(Browser.getPageHeight()));
        Canvas canvas = new Canvas(800, 600, TeaDemo2D.initScaleStrategy());
        DisplayMode displayMode = new DisplayMode(canvas, 60);
        TeaRenderer renderer = TeaDemo2D.initRenderer(displayMode);
        renderer.start(new Demo2D(), TeaDemo2D::logError);
    }

    private static TeaRenderer initRenderer(DisplayMode displayMode) {
        PostData queryString = BrowserDOM.getQueryString();
        if (queryString.contains("webgl")) {
            return TeaRenderer.withWebGL(displayMode);
        }
        if (queryString.contains("pixi")) {
            return TeaRenderer.withPixi(displayMode);
        }
        if (queryString.contains("three")) {
            return TeaRenderer.withThree(displayMode);
        }
        return TeaRenderer.withCanvas(displayMode);
    }

    private static ScaleStrategy initScaleStrategy() {
        PostData queryString = BrowserDOM.getQueryString();
        if (queryString.contains("canvas")) {
            return ScaleStrategy.balanced();
        }
        return ScaleStrategy.flexible();
    }

    private static void logError(SceneContext context, Exception cause) {
        Browser.log("----");
        Browser.log(cause.getMessage());
        Browser.log("----");
    }
}

