/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.math;

import nl.colorize.multimedialib.math.Point2D;
import nl.colorize.multimedialib.math.Rect;
import nl.colorize.multimedialib.math.Shape;

public final class Line
implements Shape {
    private final Point2D start;
    private final Point2D end;

    public Line(Point2D start, Point2D end) {
        this.start = start;
        this.end = end;
    }

    public Line(float startX, float startY, float endX, float endY) {
        this(new Point2D(startX, startY), new Point2D(endX, endY));
    }

    @Override
    public boolean contains(Point2D p) {
        return p.equals(this.start) || p.equals(this.end);
    }

    @Override
    public Rect getBoundingBox() {
        float x0 = Math.min(this.start.getX(), this.end.getX());
        float y0 = Math.min(this.start.getY(), this.end.getY());
        float x1 = Math.max(this.start.getX(), this.end.getX());
        float y1 = Math.max(this.start.getY(), this.end.getY());
        return Rect.fromPoints(x0, y0, x1, y1);
    }

    @Override
    public Line reposition(Point2D offset) {
        return new Line(this.start.getX() + offset.getX(), this.start.getY() + offset.getY(), this.end.getX() + offset.getX(), this.end.getY() + offset.getY());
    }

    public String toString() {
        return this.start + " -> " + this.end;
    }

    public Point2D getStart() {
        return this.start;
    }

    public Point2D getEnd() {
        return this.end;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Line)) {
            return false;
        }
        Line other = (Line)o;
        Point2D this$start = this.getStart();
        Point2D other$start = other.getStart();
        if (this$start == null ? other$start != null : !((Object)this$start).equals(other$start)) {
            return false;
        }
        Point2D this$end = this.getEnd();
        Point2D other$end = other.getEnd();
        return !(this$end == null ? other$end != null : !((Object)this$end).equals(other$end));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Point2D $start = this.getStart();
        result = result * 59 + ($start == null ? 43 : ((Object)$start).hashCode());
        Point2D $end = this.getEnd();
        result = result * 59 + ($end == null ? 43 : ((Object)$end).hashCode());
        return result;
    }
}

