/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.math;

import com.google.common.base.Preconditions;
import java.math.RoundingMode;
import java.text.NumberFormat;

public final class MathUtils {
    public static final float EPSILON = 0.001f;

    private MathUtils() {
    }

    public static int floor(float n) {
        return (int)n;
    }

    public static int clamp(int value, int min, int max) {
        return Math.min(Math.max(value, min), max);
    }

    public static float clamp(float value, float min, float max) {
        return Math.min(Math.max(value, min), max);
    }

    public static long clamp(long value, long min, long max) {
        return Math.min(Math.max(value, min), max);
    }

    public static float angleDistance(float a, float b) {
        float phi = Math.abs(b - a) % 360.0f;
        if (phi > 180.0f) {
            return 360.0f - phi;
        }
        return phi;
    }

    public static String format(float n, int decimals) {
        Preconditions.checkArgument((decimals >= 0 ? 1 : 0) != 0, (Object)("Invalid number of decimals: " + decimals));
        NumberFormat format = NumberFormat.getInstance();
        format.setMinimumFractionDigits(decimals);
        format.setMaximumFractionDigits(decimals);
        format.setRoundingMode(RoundingMode.UP);
        return format.format(n);
    }
}

