/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.math;

import nl.colorize.multimedialib.math.Point2D;

public final class Vector {
    private final float direction;
    private final float magnitude;

    public Vector(float direction, float magnitude) {
        this.direction = direction;
        this.magnitude = Math.max(magnitude, 0.0f);
    }

    public float getX() {
        return this.magnitude * (float)Math.cos(Math.toRadians(this.direction));
    }

    public float getY() {
        return this.magnitude * (float)Math.sin(Math.toRadians(this.direction));
    }

    public boolean isOrigin() {
        return this.magnitude < 0.001f;
    }

    public Vector withDirection(float newDirection) {
        return new Vector(newDirection, this.magnitude);
    }

    public Vector withMagnitude(float newMagnitude) {
        return new Vector(this.direction, newMagnitude);
    }

    public String toString() {
        return String.format("[ %d %d ]", Math.round(this.direction), Math.round(this.magnitude));
    }

    public static Vector fromPoint(Point2D p) {
        if (p.isOrigin()) {
            return new Vector(0.0f, 0.0f);
        }
        float direction = (float)Math.toDegrees(Math.atan2(p.getY(), p.getX()));
        float magnitude = new Point2D(0.0f, 0.0f).distanceTo(p);
        return new Vector(direction, magnitude);
    }

    public float getDirection() {
        return this.direction;
    }

    public float getMagnitude() {
        return this.magnitude;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Vector)) {
            return false;
        }
        Vector other = (Vector)o;
        if (Float.compare(this.getDirection(), other.getDirection()) != 0) {
            return false;
        }
        return Float.compare(this.getMagnitude(), other.getMagnitude()) == 0;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getDirection());
        result = result * 59 + Float.floatToIntBits(this.getMagnitude());
        return result;
    }
}

