/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.java2d;

import com.google.common.base.Preconditions;
import java.awt.image.BufferedImage;
import nl.colorize.multimedialib.math.Region;
import nl.colorize.multimedialib.renderer.FilePointer;
import nl.colorize.multimedialib.stage.ColorRGB;
import nl.colorize.multimedialib.stage.Image;

public class AWTImage
implements Image {
    private BufferedImage image;
    private FilePointer origin;

    public AWTImage(BufferedImage image, FilePointer origin) {
        Preconditions.checkArgument((image != null ? 1 : 0) != 0, (Object)("Null image originating from " + origin));
        this.image = image;
        this.origin = origin;
    }

    public AWTImage(BufferedImage image) {
        this(image, null);
    }

    public BufferedImage getImage() {
        return this.image;
    }

    @Override
    public Region getRegion() {
        return new Region(0, 0, this.image.getWidth(), this.image.getHeight());
    }

    @Override
    public Image extractRegion(Region region) {
        BufferedImage subImage = this.image.getSubimage(region.x(), region.y(), region.width(), region.height());
        return new AWTImage(subImage, this.origin);
    }

    @Override
    public ColorRGB getColor(int x, int y) {
        Preconditions.checkArgument((x >= 0 && x < this.getWidth() && y >= 0 && y < this.getHeight() ? 1 : 0) != 0, (Object)("Invalid coordinate: " + x + ", " + y));
        int rgba = this.image.getRGB(x, y);
        return new ColorRGB(rgba);
    }

    @Override
    public int getAlpha(int x, int y) {
        Preconditions.checkArgument((x >= 0 && x < this.getWidth() && y >= 0 && y < this.getHeight() ? 1 : 0) != 0, (Object)("Invalid coordinate: " + x + ", " + y));
        int rgba = this.image.getRGB(x, y);
        int alpha = rgba >> 24 & 0xFF;
        return Math.round((float)alpha / 2.55f);
    }

    public String toString() {
        if (this.origin == null) {
            return "AWTImage";
        }
        return "AWTImage[" + this.origin + "]";
    }
}

