/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.java2d;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import nl.colorize.multimedialib.stage.Audio;
import nl.colorize.util.LogHelper;
import nl.colorize.util.ResourceFile;

public class JavaSoundPlayer
implements Audio,
LineListener {
    private ResourceFile file;
    private Clip playing;
    private static final Logger LOGGER = LogHelper.getLogger(JavaSoundPlayer.class);

    public JavaSoundPlayer(ResourceFile file) {
        this.file = file;
    }

    @Override
    public void play(int volume, boolean loop) {
        Preconditions.checkArgument((volume >= 0 && volume <= 100 ? 1 : 0) != 0, (Object)("Invalid volume: " + volume));
        if (this.playing != null) {
            return;
        }
        try (AudioInputStream mp3Stream = AudioSystem.getAudioInputStream(this.file.openStream());){
            AudioFormat pcmFormat = this.convertAudioFormat(mp3Stream.getFormat());
            try (AudioInputStream pcmStream = AudioSystem.getAudioInputStream(pcmFormat, mp3Stream);){
                this.playing = AudioSystem.getClip();
                this.playing.addLineListener(this);
                this.playing.open(pcmStream);
                FloatControl gainControl = (FloatControl)this.playing.getControl(FloatControl.Type.MASTER_GAIN);
                gainControl.setValue(20.0f * (float)Math.log10((float)volume / 100.0f));
                if (loop) {
                    this.playing.loop(-1);
                } else {
                    this.playing.start();
                }
            }
        }
        catch (IOException | LineUnavailableException | UnsupportedAudioFileException e) {
            LOGGER.log(Level.WARNING, "Exception during audio playback", e);
        }
    }

    private AudioFormat convertAudioFormat(AudioFormat original) {
        return new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, original.getSampleRate(), 16, original.getChannels(), original.getChannels() * 2, original.getSampleRate(), false);
    }

    @Override
    public void stop() {
        if (this.playing != null) {
            try {
                this.playing.close();
                this.playing = null;
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Error while closing audio clip", e);
            }
        }
    }

    @Override
    public void update(LineEvent event) {
        if (event.getType() == LineEvent.Type.STOP) {
            this.stop();
        }
    }
}

