/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.libgdx;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.PerspectiveCamera;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.TextureData;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.g3d.Attribute;
import com.badlogic.gdx.graphics.g3d.Environment;
import com.badlogic.gdx.graphics.g3d.ModelBatch;
import com.badlogic.gdx.graphics.g3d.ModelInstance;
import com.badlogic.gdx.graphics.g3d.attributes.ColorAttribute;
import com.badlogic.gdx.graphics.g3d.environment.DirectionalLight;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Vector3;
import com.google.common.base.Preconditions;
import com.google.common.collect.Streams;
import java.util.List;
import nl.colorize.multimedialib.math.Circle;
import nl.colorize.multimedialib.math.Line;
import nl.colorize.multimedialib.math.Point3D;
import nl.colorize.multimedialib.math.Polygon;
import nl.colorize.multimedialib.math.Rect;
import nl.colorize.multimedialib.math.SegmentedLine;
import nl.colorize.multimedialib.renderer.Canvas;
import nl.colorize.multimedialib.renderer.libgdx.GDXBitmapFont;
import nl.colorize.multimedialib.renderer.libgdx.GDXImage;
import nl.colorize.multimedialib.renderer.libgdx.GDXMediaLoader;
import nl.colorize.multimedialib.renderer.libgdx.GDXModel;
import nl.colorize.multimedialib.stage.Align;
import nl.colorize.multimedialib.stage.ColorRGB;
import nl.colorize.multimedialib.stage.Container;
import nl.colorize.multimedialib.stage.Graphic2D;
import nl.colorize.multimedialib.stage.Primitive;
import nl.colorize.multimedialib.stage.Sprite;
import nl.colorize.multimedialib.stage.Stage;
import nl.colorize.multimedialib.stage.StageVisitor;
import nl.colorize.multimedialib.stage.Text;
import nl.colorize.multimedialib.stage.Transform;
import nl.colorize.multimedialib.stage.World3D;
import nl.colorize.util.stats.Cache;

public class GDXGraphics
implements StageVisitor {
    private Canvas canvas;
    private SpriteBatch spriteBatch;
    private ShapeRenderer shapeBatch;
    private Cache<MaskTexture, TextureRegion> maskCache;
    private PerspectiveCamera camera;
    private DirectionalLight light;
    private Environment environment;
    private ModelBatch modelBatch;
    private static final int FIELD_OF_VIEW = 75;
    private static final float NEAR_PLANE = 1.0f;
    private static final float FAR_PLANE = 300.0f;
    private static final int CIRCLE_SEGMENTS = 32;
    private static final int MASK_CACHE_SIZE = 1024;

    protected GDXGraphics(Canvas canvas) {
        this.canvas = canvas;
        this.maskCache = Cache.from(this::createMask, (int)1024);
        this.prepareWorld();
        this.restartBatch();
    }

    private void prepareWorld() {
        this.camera = new PerspectiveCamera(75.0f, (float)Gdx.graphics.getWidth(), (float)Gdx.graphics.getHeight());
        this.camera.near = 1.0f;
        this.camera.far = 300.0f;
        this.camera.update();
        this.light = new DirectionalLight();
        this.environment = new Environment();
        this.environment.add(this.light);
    }

    protected void restartBatch() {
        this.spriteBatch = new SpriteBatch();
        this.shapeBatch = new ShapeRenderer();
        this.modelBatch = new ModelBatch();
    }

    @Override
    public void prepareStage(Stage stage) {
    }

    @Override
    public void onGraphicAdded(Container parent, Graphic2D graphic) {
    }

    @Override
    public void onGraphicRemoved(Container parent, Graphic2D graphic) {
    }

    @Override
    public boolean visitGraphic(Graphic2D graphic) {
        return graphic.getTransform().isVisible();
    }

    @Override
    public void drawBackground(ColorRGB backgroundColor) {
        this.switchMode(false, true);
        this.shapeBatch.setColor(this.convertColor(backgroundColor));
        this.shapeBatch.rect(0.0f, 0.0f, (float)Gdx.graphics.getWidth(), (float)Gdx.graphics.getHeight());
    }

    @Override
    public void drawLine(Primitive graphic, Line line) {
        float x0 = this.toScreenX(line.getStart().getX());
        float y0 = this.toScreenY(line.getStart().getY());
        float x1 = this.toScreenX(line.getEnd().getX());
        float y1 = this.toScreenY(line.getEnd().getY());
        this.switchMode(false, false);
        Gdx.gl.glEnable(3042);
        this.shapeBatch.begin(ShapeRenderer.ShapeType.Line);
        this.shapeBatch.setColor(this.convertColor(graphic.getColor()));
        this.shapeBatch.line(x0, y0, x1, y1);
        this.shapeBatch.end();
    }

    @Override
    public void drawSegmentedLine(Primitive graphic, SegmentedLine line) {
        this.switchMode(false, false);
        Gdx.gl.glEnable(3042);
        this.shapeBatch.begin(ShapeRenderer.ShapeType.Line);
        this.shapeBatch.setColor(this.convertColor(graphic.getColor()));
        for (Line segment : line.getSegments()) {
            float x0 = this.toScreenX(segment.getStart().getX());
            float y0 = this.toScreenY(segment.getStart().getY());
            float x1 = this.toScreenX(segment.getEnd().getX());
            float y1 = this.toScreenY(segment.getEnd().getY());
            this.shapeBatch.line(x0, y0, x1, y1);
        }
        this.shapeBatch.end();
    }

    @Override
    public void drawRect(Primitive graphic, Rect rect) {
        Transform transform = graphic.getGlobalTransform();
        float x = this.toScreenX(rect.getX());
        float y = this.toScreenY(rect.getEndY());
        float width = rect.getWidth() * this.canvas.getZoomLevel();
        float height = rect.getHeight() * this.canvas.getZoomLevel();
        this.switchMode(false, true);
        this.shapeBatch.setColor(this.convertColor(graphic.getColor(), transform.getAlpha()));
        this.shapeBatch.rect(x, y, width, height);
    }

    @Override
    public void drawCircle(Primitive graphic, Circle circle) {
        Transform transform = graphic.getGlobalTransform();
        float x = this.toScreenX(circle.getCenter().getX());
        float y = this.toScreenY(circle.getCenter().getY());
        float radius = circle.getRadius() * this.canvas.getZoomLevel();
        this.switchMode(false, true);
        this.shapeBatch.setColor(this.convertColor(graphic.getColor(), transform.getAlpha()));
        this.shapeBatch.circle(x, y, radius, 32);
    }

    @Override
    public void drawPolygon(Primitive graphic, Polygon polygon) {
        Transform transform = graphic.getGlobalTransform();
        if (polygon.getNumPoints() == 3) {
            this.drawTriangle(polygon.getPoints(), graphic.getColor(), transform.getAlpha());
        } else {
            for (Polygon triangle : polygon.subdivide()) {
                this.drawTriangle(triangle.getPoints(), graphic.getColor(), transform.getAlpha());
            }
        }
    }

    private void drawTriangle(float[] vertices, ColorRGB color, float alpha) {
        this.switchMode(false, true);
        this.shapeBatch.setColor(this.convertColor(color, alpha));
        this.shapeBatch.triangle(this.toScreenX(vertices[0]), this.toScreenY(vertices[1]), this.toScreenX(vertices[2]), this.toScreenY(vertices[3]), this.toScreenX(vertices[4]), this.toScreenY(vertices[5]));
    }

    @Override
    public void drawSprite(Sprite sprite) {
        TextureRegion textureRegion = ((GDXImage)sprite.getCurrentGraphics()).getTextureRegion();
        Transform transform = sprite.getGlobalTransform();
        this.drawSprite(textureRegion, transform);
    }

    private void drawSprite(TextureRegion textureRegion, Transform transform) {
        float screenX = this.toScreenX(transform.getPosition().getX());
        float screenY = this.toScreenY(transform.getPosition().getY());
        float screenWidth = (float)textureRegion.getRegionWidth() * this.canvas.getZoomLevel();
        float screenHeight = (float)textureRegion.getRegionHeight() * this.canvas.getZoomLevel();
        if (transform.getMaskColor() != null) {
            textureRegion = (TextureRegion)this.maskCache.get((Object)new MaskTexture(textureRegion, transform.getMaskColor()));
        }
        this.switchMode(true, false);
        this.spriteBatch.setColor(1.0f, 1.0f, 1.0f, transform.getAlpha() / 100.0f);
        this.spriteBatch.draw(textureRegion, screenX - screenWidth / 2.0f, screenY - screenHeight / 2.0f, screenWidth / 2.0f, screenHeight / 2.0f, screenWidth, screenHeight, transform.getScaleX() / 100.0f, transform.getScaleY() / 100.0f, -transform.getRotation());
    }

    private TextureRegion createMask(MaskTexture config) {
        TextureRegion original = config.original;
        TextureData textureData = original.getTexture().getTextureData();
        textureData.prepare();
        Pixmap pixels = textureData.consumePixmap();
        Pixmap mask = new Pixmap(original.getRegionWidth(), original.getRegionHeight(), Pixmap.Format.RGBA8888);
        for (int x = 0; x < original.getRegionWidth(); ++x) {
            for (int y = 0; y < original.getRegionHeight(); ++y) {
                int rgba = pixels.getPixel(original.getRegionX() + x, original.getRegionY() + y);
                int maskRGBA = Color.rgba8888((Color)this.convertColor(config.color, new Color((int)rgba).a * 100.0f));
                mask.drawPixel(x, y, maskRGBA);
            }
        }
        Texture texture = new Texture(mask);
        pixels.dispose();
        mask.dispose();
        return new TextureRegion(texture);
    }

    @Override
    public void drawText(Text text) {
        GDXBitmapFont baseFont = (GDXBitmapFont)text.getFont();
        GDXBitmapFont displayFont = (GDXBitmapFont)baseFont.scale(this.canvas);
        Transform transform = text.getGlobalTransform();
        float screenX = this.toScreenX(transform.getPosition().getX());
        int align = this.getTextAlign(text.getAlign());
        this.switchMode(true, false);
        text.forLines((i, line) -> {
            float lineY = transform.getPosition().getY() + (float)i.intValue() * text.getLineHeight();
            float screenY = this.toScreenY(lineY - 0.75f * (float)displayFont.getStyle().size());
            displayFont.getBitmapFont().draw((Batch)this.spriteBatch, (CharSequence)line, screenX, screenY, 0.0f, align, false);
        });
    }

    private int getTextAlign(Align align) {
        return switch (align) {
            case Align.LEFT -> 8;
            case Align.CENTER -> 1;
            case Align.RIGHT -> 16;
            default -> throw new AssertionError();
        };
    }

    private float toScreenX(float x) {
        return this.canvas.toScreenX(x);
    }

    public float toScreenY(float y) {
        return (float)Gdx.graphics.getHeight() - this.canvas.toScreenY(y);
    }

    private Color convertColor(ColorRGB color, float alpha) {
        return new Color((float)color.r() / 255.0f, (float)color.g() / 255.0f, (float)color.b() / 255.0f, alpha / 100.0f);
    }

    private Color convertColor(ColorRGB color) {
        return this.convertColor(color, 100.0f);
    }

    protected void switchMode(boolean sprites, boolean shapes) {
        Preconditions.checkArgument((!sprites || !shapes ? 1 : 0) != 0, (Object)"Invalid drawing mode");
        if (sprites) {
            this.endShapeBatch();
            this.beginSpriteBatch();
        } else if (shapes) {
            this.endSpriteBatch();
            this.beginShapeBatch();
        } else {
            this.endSpriteBatch();
            this.endShapeBatch();
        }
    }

    private void beginSpriteBatch() {
        if (!this.spriteBatch.isDrawing()) {
            this.spriteBatch.begin();
        }
    }

    private void endSpriteBatch() {
        if (this.spriteBatch.isDrawing()) {
            this.spriteBatch.end();
        }
    }

    private void beginShapeBatch() {
        if (!this.shapeBatch.isDrawing()) {
            Gdx.gl.glEnable(3042);
            this.shapeBatch.begin(ShapeRenderer.ShapeType.Filled);
        }
    }

    private void endShapeBatch() {
        if (this.shapeBatch.isDrawing()) {
            this.shapeBatch.end();
        }
    }

    public void render3D(World3D layer) {
        this.camera.position.set(this.toVector(layer.getCameraPosition()));
        this.camera.up.set(0.0f, 1.0f, 0.0f);
        this.camera.lookAt(this.toVector(layer.getCameraTarget()));
        this.camera.update();
        Color ambient = GDXMediaLoader.toColor(layer.getAmbientLight());
        this.environment.set((Attribute)new ColorAttribute(ColorAttribute.AmbientLight, ambient));
        Color lightColor = GDXMediaLoader.toColor(layer.getLightColor());
        Vector3 lightPosition = this.toVector(layer.getLightPosition());
        this.light.set(lightColor, lightPosition);
        List<ModelInstance> displayList = this.updateDisplayList(layer);
        this.modelBatch.begin((Camera)this.camera);
        this.modelBatch.render(displayList, this.environment);
        this.modelBatch.end();
    }

    private List<ModelInstance> updateDisplayList(World3D world) {
        return Streams.stream(world.getChildren()).map(model -> (GDXModel)model).map(gdxModel -> gdxModel.getInstance()).toList();
    }

    private Vector3 toVector(Point3D point) {
        return new Vector3(point.getX(), point.getY(), point.getZ());
    }

    protected void dispose() {
        this.endSpriteBatch();
        this.endShapeBatch();
        this.spriteBatch.dispose();
        this.shapeBatch.dispose();
        this.modelBatch.dispose();
    }

    private record MaskTexture(TextureRegion original, ColorRGB color) {
    }
}

