/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.teavm;

import com.google.common.base.Preconditions;
import nl.colorize.multimedialib.stage.Audio;
import nl.colorize.util.Promise;
import org.teavm.jso.dom.html.HTMLAudioElement;
import org.teavm.jso.dom.html.HTMLMediaElement;

public class TeaAudio
implements Audio {
    private Promise<HTMLAudioElement> audioPromise;

    protected TeaAudio(Promise<HTMLAudioElement> audioPromise) {
        this.audioPromise = audioPromise;
    }

    @Override
    public void play(int volume, boolean loop) {
        Preconditions.checkArgument((volume >= 0 && volume <= 100 ? 1 : 0) != 0, (Object)("Invalid volume: " + volume));
        this.audioPromise.getValue().ifPresent(audioElement -> {
            audioElement.setVolume((float)volume / 100.0f);
            audioElement.setLoop(loop);
            audioElement.play();
        });
    }

    @Override
    public void stop() {
        this.audioPromise.getValue().ifPresent(audioElement -> {
            audioElement.pause();
            audioElement.setCurrentTime(0.0);
        });
    }

    public String toString() {
        return this.audioPromise.getValue().map(HTMLMediaElement::getSrc).orElse("<loading>");
    }
}

