/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.teavm;

import com.google.common.base.Preconditions;
import java.util.Optional;
import java.util.UUID;
import nl.colorize.multimedialib.math.Region;
import nl.colorize.multimedialib.stage.ColorRGB;
import nl.colorize.multimedialib.stage.Image;
import nl.colorize.util.Promise;
import org.teavm.jso.browser.Window;
import org.teavm.jso.canvas.CanvasImageSource;
import org.teavm.jso.canvas.CanvasRenderingContext2D;
import org.teavm.jso.dom.html.HTMLCanvasElement;
import org.teavm.jso.dom.html.HTMLDocument;
import org.teavm.jso.dom.html.HTMLImageElement;
import org.teavm.jso.typedarrays.Uint8ClampedArray;

public class TeaImage
implements Image {
    private UUID id = UUID.randomUUID();
    private Promise<HTMLImageElement> imagePromise;
    private Region region;
    private CanvasRenderingContext2D imageData;
    private static final Region IMAGE_LOADING_REGION = new Region(0, 0, 1, 1);
    private static final int[] UNKNOWN_RGBA = new int[]{0, 0, 0, 0};

    protected TeaImage(Promise<HTMLImageElement> imagePromise, Region region) {
        this.imagePromise = imagePromise;
        this.region = region;
    }

    public Optional<HTMLImageElement> getImageElement() {
        return this.imagePromise.getValue();
    }

    public boolean isLoaded() {
        return this.imagePromise.getValue().isPresent();
    }

    @Override
    public Region getRegion() {
        if (this.region == null) {
            return this.imagePromise.getValue().map(img -> new Region(0, 0, img.getWidth(), img.getHeight())).orElse(IMAGE_LOADING_REGION);
        }
        return this.region;
    }

    @Override
    public TeaImage extractRegion(Region region) {
        return new TeaImage(this.imagePromise, region);
    }

    @Override
    public ColorRGB getColor(int x, int y) {
        int[] rgba = this.getImageData(x, y);
        return new ColorRGB(rgba[0], rgba[1], rgba[2]);
    }

    @Override
    public int getAlpha(int x, int y) {
        int[] rgba = this.getImageData(x, y);
        return Math.round((float)rgba[3] / 2.55f);
    }

    private int[] getImageData(int x, int y) {
        HTMLImageElement img = this.imagePromise.getValue().orElse(null);
        if (img == null) {
            return UNKNOWN_RGBA;
        }
        if (this.imageData == null) {
            HTMLDocument document = Window.current().getDocument();
            HTMLCanvasElement canvas = (HTMLCanvasElement)document.createElement("canvas");
            this.imageData = (CanvasRenderingContext2D)canvas.getContext("2d");
            this.imageData.drawImage((CanvasImageSource)img, 0.0, 0.0);
        }
        Uint8ClampedArray rgba = this.imageData.getImageData((double)x, (double)y, 1.0, 1.0).getData();
        return new int[]{rgba.get(0), rgba.get(1), rgba.get(2), rgba.get(3)};
    }

    public TeaImage forParentImage() {
        Preconditions.checkState((boolean)this.isLoaded(), (Object)"Image is still loading");
        if (this.region == null) {
            return this;
        }
        return new TeaImage(this.imagePromise, null);
    }

    public boolean isFullImage() {
        return this.region == null;
    }

    public String toString() {
        return this.imagePromise.thenMap(HTMLImageElement::getSrc).getValue().orElse("<loading>");
    }

    public UUID getId() {
        return this.id;
    }

    public Promise<HTMLImageElement> getImagePromise() {
        return this.imagePromise;
    }
}

