/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.scene;

import com.google.common.base.Preconditions;
import java.util.function.BiPredicate;
import nl.colorize.multimedialib.scene.Timer;
import nl.colorize.multimedialib.scene.Updatable;
import nl.colorize.util.stats.Tuple;
import nl.colorize.util.stats.TupleList;

public class StateMachine<S>
implements Updatable {
    private S activeState;
    private Timer activeStateTimer;
    private S nextState;
    private BiPredicate<S, S> allowedTransitions;

    public StateMachine(S initialState) {
        this.activeState = initialState;
        this.activeStateTimer = Timer.infinite();
        this.nextState = null;
        this.allowedTransitions = (a, b) -> true;
    }

    private boolean isTransitionAllowed(S requestedState) {
        return !this.activeState.equals(requestedState) && this.allowedTransitions.test(this.activeState, requestedState);
    }

    public boolean changeState(S requestedState) {
        Preconditions.checkArgument((requestedState != null ? 1 : 0) != 0, (Object)"Requested state cannot be null");
        if (!this.isTransitionAllowed(requestedState)) {
            return false;
        }
        this.activeState = requestedState;
        this.activeStateTimer = Timer.infinite();
        this.nextState = null;
        return true;
    }

    public boolean changeState(S requestedState, float duration) {
        return this.changeState(requestedState, duration, this.activeState);
    }

    public boolean changeState(S requestedState, float duration, S next) {
        Preconditions.checkArgument((requestedState != null ? 1 : 0) != 0, (Object)"Requested state cannot be null");
        Preconditions.checkArgument((next != null ? 1 : 0) != 0, (Object)"Next state cannot be null");
        if (!this.isTransitionAllowed(requestedState)) {
            return false;
        }
        this.activeState = requestedState;
        this.activeStateTimer = new Timer(duration);
        this.nextState = next;
        return true;
    }

    public void allowTransitions(BiPredicate<S, S> callback) {
        this.allowedTransitions = callback;
    }

    public void allowTransitions(TupleList<S, S> allowed) {
        Preconditions.checkArgument((!allowed.isEmpty() ? 1 : 0) != 0, (Object)"Provided list is empty");
        this.allowedTransitions = (a, b) -> allowed.contains((Object)Tuple.of((Object)a, (Object)b));
    }

    @Override
    public void update(float deltaTime) {
        S s = this.activeState;
        if (s instanceof Updatable) {
            Updatable updatableState = (Updatable)s;
            updatableState.update(deltaTime);
        }
        this.activeStateTimer.update(deltaTime);
        if (this.activeStateTimer.isCompleted() && this.nextState != null) {
            this.changeState(this.nextState);
        }
    }

    public S getActiveState() {
        return this.activeState;
    }

    public Timer getActiveStateTimer() {
        return this.activeStateTimer;
    }
}

