/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.stage;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import nl.colorize.multimedialib.math.Point2D;
import nl.colorize.multimedialib.math.Rect;
import nl.colorize.multimedialib.scene.StateMachine;
import nl.colorize.multimedialib.stage.Animation;
import nl.colorize.multimedialib.stage.Graphic2D;
import nl.colorize.multimedialib.stage.Image;
import nl.colorize.multimedialib.stage.StageLocation;
import nl.colorize.multimedialib.stage.Transform;

public class Sprite
implements Graphic2D {
    private StageLocation location = new StageLocation();
    private Map<String, Animation> graphics = new HashMap<String, Animation>();
    private StateMachine<String> state = new StateMachine<String>("$$default");
    private static final String DEFAULT_STATE = "$$default";

    public Sprite() {
    }

    public Sprite(Animation anim) {
        this();
        this.addGraphics(DEFAULT_STATE, anim);
    }

    public Sprite(Image image) {
        this();
        this.addGraphics(DEFAULT_STATE, image);
    }

    public void addGraphics(String stateName, Animation stateGraphics) {
        Preconditions.checkArgument((!this.graphics.containsKey(stateName) ? 1 : 0) != 0, (Object)("Sprite already contains graphics for " + stateName));
        this.graphics.put(stateName, stateGraphics);
        if (this.graphics.size() == 1) {
            this.changeGraphics(stateName);
        }
    }

    public void addGraphics(String stateName, Image stateGraphics) {
        this.addGraphics(stateName, new Animation(stateGraphics));
    }

    public void changeGraphics(String stateName) {
        Preconditions.checkArgument((boolean)this.graphics.containsKey(stateName), (Object)("Sprite does not contain graphics for " + stateName));
        this.state.changeState(stateName);
    }

    public void resetCurrentGraphics() {
        this.state.getActiveStateTimer().reset();
    }

    @Deprecated
    public String getActiveState() {
        return this.state.getActiveState();
    }

    public Set<String> getPossibleStates() {
        return this.graphics.keySet();
    }

    public boolean hasGraphics(String stateName) {
        return this.graphics.containsKey(stateName);
    }

    public Animation getGraphics(String stateName) {
        Animation stateGraphics = this.graphics.get(stateName);
        Preconditions.checkArgument((stateGraphics != null ? 1 : 0) != 0, (Object)("Sprite does not contain graphics for " + stateName));
        return stateGraphics;
    }

    @Deprecated
    public Animation getCurrentStateGraphics() {
        return this.graphics.get(this.state.getActiveState());
    }

    public Image getCurrentGraphics() {
        Animation currentGraphics = this.graphics.get(this.state.getActiveState());
        float time = this.state.getActiveStateTimer().getTime();
        return currentGraphics.getFrameAtTime(time);
    }

    public int getCurrentWidth() {
        return this.getCurrentGraphics().getWidth();
    }

    public int getCurrentHeight() {
        return this.getCurrentGraphics().getHeight();
    }

    @Override
    public void update(float deltaTime) {
        Preconditions.checkState((!this.graphics.isEmpty() ? 1 : 0) != 0, (Object)"Sprite does not contain any graphics");
        this.state.update(deltaTime);
    }

    @Override
    public Rect getStageBounds() {
        Transform globalTransform = this.getGlobalTransform();
        Point2D position = globalTransform.getPosition();
        float width = Math.max((float)this.getCurrentWidth() * (globalTransform.getScaleX() / 100.0f), 1.0f);
        float height = Math.max((float)this.getCurrentHeight() * (globalTransform.getScaleY() / 100.0f), 1.0f);
        return new Rect(position.getX() - width / 2.0f, position.getY() - height / 2.0f, width, height);
    }

    public Sprite copy() {
        Sprite copy = new Sprite();
        for (Map.Entry<String, Animation> entry : this.graphics.entrySet()) {
            copy.addGraphics(entry.getKey(), entry.getValue());
        }
        copy.changeGraphics(this.state.getActiveState());
        copy.getTransform().set(this.getTransform());
        return copy;
    }

    public String toString() {
        return "Sprite [" + this.getCurrentGraphics() + "]";
    }

    @Override
    public StageLocation getLocation() {
        return this.location;
    }
}

