/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.stage;

import java.util.logging.Logger;
import nl.colorize.multimedialib.math.Circle;
import nl.colorize.multimedialib.math.Line;
import nl.colorize.multimedialib.math.Polygon;
import nl.colorize.multimedialib.math.Rect;
import nl.colorize.multimedialib.math.SegmentedLine;
import nl.colorize.multimedialib.math.Shape;
import nl.colorize.multimedialib.renderer.Canvas;
import nl.colorize.multimedialib.renderer.GraphicsMode;
import nl.colorize.multimedialib.scene.Updatable;
import nl.colorize.multimedialib.stage.ColorRGB;
import nl.colorize.multimedialib.stage.Container;
import nl.colorize.multimedialib.stage.Graphic2D;
import nl.colorize.multimedialib.stage.Primitive;
import nl.colorize.multimedialib.stage.Sprite;
import nl.colorize.multimedialib.stage.StageVisitor;
import nl.colorize.multimedialib.stage.Text;
import nl.colorize.multimedialib.stage.Transform;
import nl.colorize.multimedialib.stage.World3D;
import nl.colorize.util.LogHelper;

public class Stage
implements Updatable {
    private final Canvas canvas;
    private ColorRGB backgroundColor;
    private final Container root;
    private final World3D world;
    private static final Logger LOGGER = LogHelper.getLogger(Stage.class);

    public Stage(GraphicsMode graphicsMode, Canvas canvas) {
        this.canvas = canvas;
        this.backgroundColor = ColorRGB.BLACK;
        this.root = new Container();
        this.world = graphicsMode == GraphicsMode.MODE_3D ? new World3D() : null;
    }

    @Override
    public void update(float deltaTime) {
        this.root.update(deltaTime);
        if (this.world != null) {
            this.world.update(deltaTime);
        }
    }

    public Container addContainer() {
        Container container = new Container();
        this.root.addChild(container);
        return container;
    }

    public void visit(StageVisitor visitor) {
        visitor.prepareStage(this);
        visitor.drawBackground(this.backgroundColor);
        this.visitGraphic(this.root, visitor);
    }

    private void visitGraphic(Graphic2D graphic, StageVisitor visitor) {
        if (visitor.visitGraphic(graphic)) {
            if (graphic instanceof Container) {
                Container container = (Container)graphic;
                this.visitContainer(container, visitor);
            } else if (graphic instanceof Sprite) {
                Sprite sprite = (Sprite)graphic;
                visitor.drawSprite(sprite);
            } else if (graphic instanceof Primitive) {
                Primitive primitive = (Primitive)graphic;
                this.visitPrimitive(primitive, visitor);
            } else if (graphic instanceof Text) {
                Text text = (Text)graphic;
                visitor.drawText(text);
            } else {
                LOGGER.warning("Stage contains unknown graphics type: " + graphic);
            }
        }
    }

    private void visitContainer(Container container, StageVisitor visitor) {
        for (Graphic2D added : container.getAddedChildren().flush()) {
            visitor.onGraphicAdded(container, added);
        }
        for (Graphic2D removed : container.getRemovedChildren().flush()) {
            visitor.onGraphicRemoved(container, removed);
        }
        for (Graphic2D child : container.getChildren()) {
            this.visitGraphic(child, visitor);
        }
    }

    private void visitPrimitive(Primitive graphic, StageVisitor visitor) {
        Transform globalTransform = graphic.getGlobalTransform();
        Shape displayedShape = graphic.getShape().reposition(globalTransform.getPosition());
        switch (graphic.getShapeType()) {
            case 1: {
                visitor.drawLine(graphic, (Line)displayedShape);
                break;
            }
            case 2: {
                visitor.drawRect(graphic, (Rect)displayedShape);
                break;
            }
            case 3: {
                visitor.drawCircle(graphic, (Circle)displayedShape);
                break;
            }
            case 4: {
                visitor.drawPolygon(graphic, (Polygon)displayedShape);
                break;
            }
            case 5: {
                visitor.drawSegmentedLine(graphic, (SegmentedLine)displayedShape);
                break;
            }
            default: {
                LOGGER.warning("Stage contains unknown primitive type: " + graphic);
            }
        }
    }

    public void clear() {
        this.root.clearChildren();
        if (this.world != null) {
            this.world.getChildren().clear();
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Stage\n");
        this.append(buffer, this.root, 1);
        return buffer.toString();
    }

    private void append(StringBuilder buffer, Graphic2D graphic, int depth) {
        for (int i = 0; i < depth; ++i) {
            buffer.append("    ");
        }
        buffer.append(graphic.toString());
        buffer.append("\n");
        if (graphic instanceof Container) {
            Container container = (Container)graphic;
            for (Graphic2D child : container.getChildren()) {
                if (!child.getTransform().isVisible()) continue;
                this.append(buffer, child, depth + 1);
            }
        }
    }

    public Canvas getCanvas() {
        return this.canvas;
    }

    public ColorRGB getBackgroundColor() {
        return this.backgroundColor;
    }

    public Container getRoot() {
        return this.root;
    }

    public World3D getWorld() {
        return this.world;
    }

    public void setBackgroundColor(ColorRGB backgroundColor) {
        this.backgroundColor = backgroundColor;
    }
}

