/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.stage;

import com.google.common.base.Preconditions;
import java.util.UUID;
import nl.colorize.multimedialib.stage.Container;
import nl.colorize.multimedialib.stage.Transform;

public class StageLocation {
    private UUID id = UUID.randomUUID();
    private Container parent = null;
    private Transform localTransform = new Transform();

    public void attach(Container parent) {
        Preconditions.checkState((this.parent == null ? 1 : 0) != 0, (Object)"Graphic is already attached to parent");
        this.parent = parent;
    }

    public void detach() {
        this.parent = null;
    }

    public boolean isAttached() {
        return this.parent != null;
    }

    public Transform getGlobalTransform() {
        if (this.parent == null) {
            return this.localTransform;
        }
        return this.localTransform.combine(this.parent.getGlobalTransform());
    }

    public UUID getId() {
        return this.id;
    }

    public Container getParent() {
        return this.parent;
    }

    public Transform getLocalTransform() {
        return this.localTransform;
    }
}

