/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.tool;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import nl.colorize.multimedialib.tool.SpriteAtlasPacker;
import nl.colorize.util.FileUtils;
import nl.colorize.util.LogHelper;
import nl.colorize.util.cli.Arg;
import nl.colorize.util.cli.CommandLineArgumentParser;
import nl.colorize.util.swing.Utils2D;

public class ImageManipulationTool {
    @Arg(name="input")
    protected File inputDir;
    @Arg(name="output")
    protected File outputDir;
    @Arg
    protected int horizontalOffset;
    @Arg
    protected int verticalOffset;
    private static final Logger LOGGER = LogHelper.getLogger(ImageManipulationTool.class);

    public static void main(String[] argv) {
        CommandLineArgumentParser argParser = new CommandLineArgumentParser("ImageManipulationTool");
        ImageManipulationTool tool = (ImageManipulationTool)argParser.parse(argv, ImageManipulationTool.class);
        try {
            tool.run();
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "I/O error during image manipulation", e);
        }
    }

    protected void run() throws IOException {
        for (File imageFile : FileUtils.walkFiles((File)this.inputDir, this::isImageFile)) {
            LOGGER.info("Processing " + imageFile.getName());
            BufferedImage image = Utils2D.loadImage((File)imageFile);
            this.processImage(image);
        }
    }

    private boolean isImageFile(File file) {
        String ext = FileUtils.getFileExtension((File)file);
        return SpriteAtlasPacker.IMAGE_FILE_EXTENSIONS.contains(ext);
    }

    private void processImage(BufferedImage original) {
        if (this.horizontalOffset > 0) {
            this.applyHorizontalOffset(original);
        }
        if (this.verticalOffset > 0) {
            this.applyVerticalOffset(original);
        }
    }

    private void applyHorizontalOffset(BufferedImage original) {
        for (int x = 0; x < original.getWidth(); x += this.horizontalOffset) {
            BufferedImage image = this.createImage(original);
            Graphics2D g2 = Utils2D.createGraphics((BufferedImage)image, (boolean)true, (boolean)true);
            g2.drawImage((Image)original, x, 0, null);
            g2.drawImage((Image)original, x - original.getWidth(), 0, null);
            g2.dispose();
            this.writePNG(image, "h-" + x + ".png");
        }
    }

    private void applyVerticalOffset(BufferedImage original) {
        for (int y = 0; y < original.getHeight(); y += this.verticalOffset) {
            BufferedImage image = this.createImage(original);
            Graphics2D g2 = Utils2D.createGraphics((BufferedImage)image, (boolean)true, (boolean)true);
            g2.drawImage((Image)original, 0, y, null);
            g2.drawImage((Image)original, 0, y - original.getHeight(), null);
            g2.dispose();
            this.writePNG(image, "v-" + y + ".png");
        }
    }

    private BufferedImage createImage(BufferedImage original) {
        return new BufferedImage(original.getWidth(), original.getHeight(), 2);
    }

    private void writePNG(BufferedImage image, String name) {
        File outputFile = new File(this.outputDir, (String)(name.endsWith(".png") ? name : name + ".png"));
        LOGGER.info("Creating " + outputFile.getAbsolutePath());
        try {
            Utils2D.savePNG((BufferedImage)image, (File)outputFile);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to write image: " + outputFile.getAbsolutePath());
        }
    }
}

