/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public record FilePointer(String path) {
    private static final Splitter PATH_SPLITTER = Splitter.on((String)"/").omitEmptyStrings();

    public FilePointer {
        Preconditions.checkArgument((!path.isEmpty() && !path.contains("\\") ? 1 : 0) != 0, (Object)("Invalid path: " + path));
        Preconditions.checkArgument((!path.startsWith("/") ? 1 : 0) != 0, (Object)("Absolute files are not allowed: " + path));
    }

    public FilePointer(File localFile) {
        this(localFile.getAbsolutePath());
    }

    public String getFileName() {
        List pathComponents = PATH_SPLITTER.splitToList((CharSequence)this.path);
        return (String)pathComponents.get(pathComponents.size() - 1);
    }

    public FilePointer sibling(String fileName) {
        ArrayList<String> pathComponents = new ArrayList<String>();
        pathComponents.addAll(PATH_SPLITTER.splitToList((CharSequence)this.path));
        pathComponents.remove(pathComponents.size() - 1);
        pathComponents.add(fileName);
        return new FilePointer(String.join((CharSequence)"/", pathComponents));
    }

    @Override
    public String toString() {
        return this.path;
    }
}

