/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.teavm;

import com.google.common.base.Preconditions;
import nl.colorize.multimedialib.stage.FontStyle;
import nl.colorize.multimedialib.stage.OutlineFont;
import nl.colorize.util.Promise;

public class TeaFont
implements OutlineFont {
    private Promise<Boolean> fontPromise;
    private FontStyle style;

    protected TeaFont(Promise<Boolean> fontPromise, FontStyle style) {
        this.fontPromise = fontPromise;
        this.style = style;
    }

    public boolean isLoaded() {
        return this.fontPromise.getValue().isPresent();
    }

    @Override
    public FontStyle getStyle() {
        return this.style;
    }

    @Override
    public OutlineFont derive(FontStyle newStyle) {
        Preconditions.checkArgument((boolean)this.style.family().equals(newStyle.family()), (Object)("Font family mismatch: expected " + this.style.family()));
        return new TeaFont(this.fontPromise, newStyle);
    }

    public String getFontString() {
        return (this.style.bold() ? "bold " : "") + this.style.size() + "px " + this.style.family();
    }
}

