/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.scene;

import com.google.common.base.Preconditions;
import java.util.Deque;
import java.util.LinkedList;
import java.util.function.BiPredicate;
import nl.colorize.multimedialib.scene.Timer;
import nl.colorize.multimedialib.scene.Updatable;
import nl.colorize.util.stats.Tuple;
import nl.colorize.util.stats.TupleList;

public class StateMachine<S>
implements Updatable {
    private Deque<RequestedState<S>> stateQueue = new LinkedList<RequestedState<S>>();
    private S defaultState;
    private BiPredicate<S, S> allowedTransitions;

    public StateMachine(S defaultState) {
        this.defaultState = defaultState;
        this.allowedTransitions = (a, b) -> true;
    }

    public boolean requestState(S nextState) {
        return this.requestState(nextState, 0.0f);
    }

    public boolean requestState(S nextState, float duration) {
        if (!this.isTransitionAllowed(nextState)) {
            return false;
        }
        boolean interruptible = duration == 0.0f;
        Timer timer = interruptible ? Timer.infinite() : new Timer(duration);
        RequestedState<S> stateInfo = new RequestedState<S>(nextState, timer, interruptible);
        this.stateQueue.offer(stateInfo);
        return true;
    }

    public void forceState(S nextState) {
        this.stateQueue.clear();
        this.requestState(nextState);
    }

    public void allowTransitions(BiPredicate<S, S> callback) {
        this.allowedTransitions = callback;
    }

    public void allowTransitions(TupleList<S, S> allowed) {
        Preconditions.checkArgument((!allowed.isEmpty() ? 1 : 0) != 0, (Object)"Provided list is empty");
        this.allowedTransitions = (a, b) -> allowed.contains((Object)Tuple.of((Object)a, (Object)b));
    }

    private boolean isTransitionAllowed(S requestedState) {
        if (this.stateQueue.isEmpty()) {
            return !requestedState.equals(this.defaultState);
        }
        Object precedingState = this.stateQueue.getLast().state;
        return !requestedState.equals(precedingState) && this.allowedTransitions.test(precedingState, requestedState);
    }

    @Override
    public void update(float deltaTime) {
        if (this.isActiveStateCompleted()) {
            this.stateQueue.pop();
        }
        if (this.stateQueue.isEmpty()) {
            this.updateState(this.defaultState, deltaTime);
            return;
        }
        RequestedState<S> active = this.stateQueue.peek();
        this.updateState(active.state, deltaTime);
        active.timer.update(deltaTime);
        if (this.isActiveStateCompleted()) {
            this.stateQueue.pop();
        }
    }

    private void updateState(S state, float deltaTime) {
        if (state instanceof Updatable) {
            Updatable updatableState = (Updatable)state;
            updatableState.update(deltaTime);
        }
    }

    public S getActiveState() {
        if (this.stateQueue.isEmpty()) {
            return this.defaultState;
        }
        RequestedState<S> active = this.stateQueue.peek();
        return active.state;
    }

    public Timer getActiveStateTimer() {
        if (this.stateQueue.isEmpty()) {
            return Timer.infinite();
        }
        RequestedState<S> active = this.stateQueue.peek();
        return active.timer;
    }

    private boolean isActiveStateCompleted() {
        if (this.stateQueue.isEmpty()) {
            return false;
        }
        RequestedState<S> active = this.stateQueue.peek();
        boolean hasNextState = this.stateQueue.size() >= 2;
        return active.timer.isCompleted() || active.interruptible && hasNextState;
    }

    private record RequestedState<S>(S state, Timer timer, boolean interruptible) {
    }
}

