/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.stage;

import com.google.common.base.Preconditions;
import java.util.Map;
import nl.colorize.multimedialib.math.Circle;
import nl.colorize.multimedialib.math.Line;
import nl.colorize.multimedialib.math.Polygon;
import nl.colorize.multimedialib.math.Rect;
import nl.colorize.multimedialib.math.SegmentedLine;
import nl.colorize.multimedialib.math.Shape;
import nl.colorize.multimedialib.stage.ColorRGB;
import nl.colorize.multimedialib.stage.Graphic2D;
import nl.colorize.multimedialib.stage.StageLocation;
import nl.colorize.multimedialib.stage.Transform;

public class Primitive
implements Graphic2D {
    private final StageLocation location = new StageLocation();
    private Shape shape;
    private ColorRGB color;
    private float stroke;
    public static final int TYPE_LINE = 1;
    public static final int TYPE_RECT = 2;
    public static final int TYPE_CIRCLE = 3;
    public static final int TYPE_POLYGON = 4;
    public static final int TYPE_SEGMENTED_LINE = 5;
    private static final Map<Class<? extends Shape>, Integer> TYPE_MAPPING = Map.of(Line.class, 1, Rect.class, 2, Circle.class, 3, Polygon.class, 4, SegmentedLine.class, 5);

    public Primitive(Shape shape, ColorRGB color) {
        this.shape = shape;
        this.color = color;
        this.stroke = 1.0f;
    }

    public Primitive(Shape shape, ColorRGB color, float alpha) {
        this(shape, color);
        this.getTransform().setAlpha(alpha);
    }

    public int getShapeType() {
        Integer type = TYPE_MAPPING.get(this.shape.getClass());
        Preconditions.checkState((type != null ? 1 : 0) != 0, (Object)("Unknown shape: " + this.shape.getClass()));
        return type;
    }

    @Override
    public void update(float deltaTime) {
    }

    @Override
    public Rect getStageBounds() {
        Transform globalTransform = this.getGlobalTransform();
        return this.shape.reposition(globalTransform.getPosition()).getBoundingBox();
    }

    public String toString() {
        return "Primitive [" + this.shape.toString() + "]";
    }

    @Override
    public StageLocation getLocation() {
        return this.location;
    }

    public Shape getShape() {
        return this.shape;
    }

    public ColorRGB getColor() {
        return this.color;
    }

    public float getStroke() {
        return this.stroke;
    }

    public void setShape(Shape shape) {
        this.shape = shape;
    }

    public void setColor(ColorRGB color) {
        this.color = color;
    }

    public void setStroke(float stroke) {
        this.stroke = stroke;
    }
}

