/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.scene;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Supplier;
import nl.colorize.multimedialib.math.Rect;
import nl.colorize.multimedialib.renderer.Canvas;
import nl.colorize.multimedialib.renderer.Pointer;
import nl.colorize.multimedialib.scene.Scene;
import nl.colorize.multimedialib.scene.SceneContext;
import nl.colorize.multimedialib.scene.Timer;
import nl.colorize.multimedialib.scene.Updatable;
import nl.colorize.multimedialib.stage.Animation;
import nl.colorize.multimedialib.stage.Graphic2D;
import nl.colorize.multimedialib.stage.Primitive;
import nl.colorize.multimedialib.stage.Sprite;
import nl.colorize.multimedialib.stage.Text;
import nl.colorize.util.animation.Interpolation;
import nl.colorize.util.animation.Timeline;

public final class Effect
implements Scene {
    private List<Updatable> frameHandlers = new ArrayList<Updatable>();
    private List<ClickHandler> clickHandlers = new ArrayList<ClickHandler>();
    private List<Runnable> completionHandlers = new ArrayList<Runnable>();
    private List<Graphic2D> linkedGraphics = new ArrayList<Graphic2D>();
    private List<BooleanSupplier> completionConditions = new ArrayList<BooleanSupplier>();
    private boolean completed = false;

    private Effect() {
    }

    public Effect addFrameHandler(Updatable handler) {
        this.frameHandlers.add(handler);
        return this;
    }

    public Effect addTimelineHandler(Timeline timeline, Consumer<Float> callback) {
        this.addFrameHandler(deltaTime -> {
            timeline.movePlayhead(deltaTime);
            callback.accept(Float.valueOf(timeline.getValue()));
        });
        this.stopIf(() -> timeline.isCompleted() && !timeline.isLoop());
        return this;
    }

    public Effect addClickHandler(Rect bounds, Runnable handler) {
        this.clickHandlers.add(new ClickHandler(() -> bounds, handler));
        return this;
    }

    public Effect addClickHandler(Graphic2D graphic, Runnable handler) {
        this.clickHandlers.add(new ClickHandler(graphic::getStageBounds, handler));
        return this;
    }

    public Effect addCompletionHandler(Runnable handler) {
        this.completionHandlers.add(handler);
        return this;
    }

    public Effect stopAfter(float duration) {
        Timer timer = new Timer(duration);
        this.addFrameHandler(timer);
        this.stopIf(timer::isCompleted);
        return this;
    }

    public Effect stopAfterAnimation(Sprite sprite) {
        return this.stopIf(() -> {
            Animation animation = sprite.getCurrentStateGraphics();
            Timer timer = sprite.getCurrentStateTimer();
            return animation.getDuration() > 0.0f && timer.getTime() >= animation.getDuration();
        });
    }

    public Effect stopIf(BooleanSupplier condition) {
        this.completionConditions.add(condition);
        return this;
    }

    public Effect linkGraphics(Graphic2D ... graphics) {
        for (Graphic2D graphic : graphics) {
            this.linkedGraphics.add(graphic);
        }
        return this;
    }

    @Deprecated
    public Effect removeAfterwards(Graphic2D ... graphics) {
        return this.linkGraphics(graphics);
    }

    @Override
    public void update(SceneContext context, float deltaTime) {
        if (!this.completed) {
            this.updateHandlers(context, deltaTime);
            if (this.checkCompleted()) {
                this.completed = true;
            }
        }
    }

    private void updateHandlers(SceneContext context, float deltaTime) {
        for (Updatable frameHandler : this.frameHandlers) {
            frameHandler.update(deltaTime);
        }
        for (Pointer pointer : context.getInput().getPointers()) {
            for (ClickHandler clickHandler : this.clickHandlers) {
                if (!pointer.isReleased(clickHandler.bounds.get())) continue;
                clickHandler.action.run();
                context.getInput().clearPointerState();
            }
        }
    }

    private boolean checkCompleted() {
        if (this.completionConditions.isEmpty()) {
            return false;
        }
        return this.completionConditions.stream().allMatch(BooleanSupplier::getAsBoolean);
    }

    @Override
    public void end(SceneContext context) {
        for (Runnable completionHandler : this.completionHandlers) {
            completionHandler.run();
        }
        for (Graphic2D graphic : this.linkedGraphics) {
            graphic.detach();
        }
    }

    @Override
    public boolean isCompleted() {
        return this.completed;
    }

    @Deprecated
    public void withLinkedGraphics(Consumer<Graphic2D> callback) {
        this.linkedGraphics.forEach(callback);
    }

    @Deprecated
    public <T extends Graphic2D> void withLinkedGraphics(Class<T> type, Consumer<T> callback) {
        this.linkedGraphics.stream().filter(graphic -> graphic.getClass().equals(type)).forEach(graphic -> callback.accept(graphic));
    }

    public Effect attach(SceneContext context) {
        context.attach(this);
        return this;
    }

    public static Effect forFrameHandler(Updatable action) {
        Effect effect = new Effect();
        effect.addFrameHandler(action);
        return effect;
    }

    public static Effect forFrameHandler(Runnable action) {
        return Effect.forFrameHandler((float deltaTime) -> action.run());
    }

    public static Effect delay(float duration, Runnable action) {
        Timer timer = new Timer(duration);
        AtomicBoolean done = new AtomicBoolean(false);
        Effect effect = new Effect();
        effect.addFrameHandler(deltaTime -> {
            timer.update(deltaTime);
            if (timer.isCompleted() && !done.get()) {
                action.run();
                done.set(true);
            }
        });
        effect.stopIf(timer::isCompleted);
        return effect;
    }

    public static Effect forTimeline(Timeline timeline, Consumer<Float> callback) {
        Effect effect = new Effect();
        effect.addTimelineHandler(timeline, callback);
        return effect;
    }

    public static Effect forClickHandler(Graphic2D graphic, Runnable handler) {
        Effect effect = new Effect();
        effect.linkGraphics(graphic);
        effect.addClickHandler(graphic, handler);
        return effect;
    }

    public static Effect forSpriteRotation(Sprite sprite, float duration) {
        Preconditions.checkArgument((duration > 0.0f ? 1 : 0) != 0, (Object)("Invalid duration: " + duration));
        Timeline timeline = new Timeline(Interpolation.LINEAR, true);
        timeline.addKeyFrame(0.0f, 0.0f);
        timeline.addKeyFrame(duration, 360.0f);
        Effect effect = new Effect();
        effect.addTimelineHandler(timeline, value -> sprite.getTransform().setRotation(value.floatValue()));
        effect.removeAfterwards(sprite);
        return effect;
    }

    public static Effect forSpriteScale(Sprite sprite, Timeline timeline) {
        Effect effect = new Effect();
        effect.addTimelineHandler(timeline, value -> sprite.getTransform().setScale(value.floatValue()));
        effect.removeAfterwards(sprite);
        return effect;
    }

    public static Effect forSpriteAlpha(Sprite sprite, Timeline timeline) {
        Effect effect = new Effect();
        effect.addTimelineHandler(timeline, value -> sprite.getTransform().setAlpha(value.floatValue()));
        effect.removeAfterwards(sprite);
        return effect;
    }

    public static Effect scaleToFit(Sprite sprite, Canvas canvas, boolean uniform) {
        return Effect.forFrameHandler(() -> {
            float scaleX = (float)canvas.getWidth() / (float)sprite.getCurrentWidth();
            float scaleY = (float)canvas.getHeight() / (float)sprite.getCurrentHeight();
            if (uniform) {
                sprite.getTransform().setScale(Math.max(scaleX, scaleY) * 100.0f);
            } else {
                sprite.getTransform().setScale(scaleX * 100.0f, scaleY * 100.0f);
            }
        });
    }

    public static Effect forPrimitiveAlpha(Primitive primitive, Timeline timeline) {
        Effect effect = new Effect();
        effect.addTimelineHandler(timeline, value -> primitive.getTransform().setAlpha(value.floatValue()));
        effect.removeAfterwards(primitive);
        return effect;
    }

    public static Effect forTextAlpha(Text text, Timeline timeline) {
        Effect effect = new Effect();
        effect.addTimelineHandler(timeline, value -> text.getTransform().setAlpha(value.floatValue()));
        effect.removeAfterwards(text);
        return effect;
    }

    public static Effect forTextAppear(Text text, float duration) {
        Preconditions.checkArgument((duration > 0.0f ? 1 : 0) != 0, (Object)("Invalid duration: " + duration));
        String originalText = text.getText();
        Timeline timeline = new Timeline();
        timeline.addKeyFrame(0.0f, 0.0f);
        timeline.addKeyFrame(duration, (float)originalText.length());
        Effect effect = new Effect();
        effect.addTimelineHandler(timeline, deltaTime -> {
            String visibleText = originalText.substring(0, (int)timeline.getValue());
            text.setText(visibleText);
        });
        return effect;
    }

    private record ClickHandler(Supplier<Rect> bounds, Runnable action) {
    }
}

