/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.stage;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import nl.colorize.multimedialib.math.Buffer;
import nl.colorize.multimedialib.math.Point2D;
import nl.colorize.multimedialib.math.Rect;
import nl.colorize.multimedialib.stage.Graphic2D;
import nl.colorize.multimedialib.stage.GraphicsProvider;
import nl.colorize.multimedialib.stage.StageLocation;

public class Container
implements Graphic2D {
    private StageLocation location = new StageLocation();
    private List<Graphic2D> children = new ArrayList<Graphic2D>();
    private Buffer<Graphic2D> addedChildren = new Buffer();
    private Buffer<Graphic2D> removedChildren = new Buffer();

    public void addChild(Graphic2D child) {
        Preconditions.checkArgument((!child.equals(this) ? 1 : 0) != 0, (Object)"Cannot add container to itself");
        Preconditions.checkArgument((!child.getLocation().isAttached() ? 1 : 0) != 0, (Object)"Graphic is already attached to a different parent");
        child.getLocation().attach(this);
        this.children.add(child);
        this.addedChildren.push(child);
    }

    public void addChild(GraphicsProvider child) {
        this.addChild(child.getContainer());
    }

    public void addChild(Graphic2D child, Point2D relativePosition) {
        this.addChild(child);
        child.getTransform().setPosition(relativePosition);
    }

    public void addChild(Graphic2D child, float relativeX, float relativeY) {
        this.addChild(child);
        child.getTransform().setPosition(relativeX, relativeY);
    }

    public Container addChildContainer() {
        Container child = new Container();
        this.addChild(child);
        return child;
    }

    public void removeChild(Graphic2D child) {
        if (this.children.remove(child)) {
            child.getLocation().detach();
            this.removedChildren.push(child);
        }
    }

    public void clearChildren() {
        this.children.forEach(this.removedChildren::push);
        this.children.clear();
        this.addedChildren.flush();
    }

    public Iterable<Graphic2D> getChildren() {
        return this.children;
    }

    public void forEach(Consumer<Graphic2D> callback) {
        this.children.forEach(callback);
    }

    public <T extends Graphic2D> void forEach(Class<T> type, Consumer<T> callback) {
        for (Graphic2D child : this.children) {
            if (child.getClass() != type) continue;
            callback.accept(child);
        }
    }

    @Override
    public void update(float deltaTime) {
        for (Graphic2D child : this.children) {
            child.update(deltaTime);
        }
    }

    @Override
    public Rect getStageBounds() {
        if (this.children.isEmpty()) {
            return new Rect(0.0f, 0.0f, 0.0f, 0.0f);
        }
        float x0 = 2.1474836E9f;
        float y0 = 2.1474836E9f;
        float x1 = -2.1474836E9f;
        float y1 = -2.1474836E9f;
        for (Graphic2D child : this.children) {
            Rect childBounds = child.getStageBounds();
            x0 = Math.min(x0, childBounds.getX());
            y0 = Math.min(y0, childBounds.getY());
            x1 = Math.max(x1, childBounds.getEndX());
            y1 = Math.max(y1, childBounds.getEndY());
        }
        return Rect.fromPoints(x0, y0, x1, y1);
    }

    public String toString() {
        return "Container";
    }

    @Override
    public StageLocation getLocation() {
        return this.location;
    }

    public Buffer<Graphic2D> getAddedChildren() {
        return this.addedChildren;
    }

    public Buffer<Graphic2D> getRemovedChildren() {
        return this.removedChildren;
    }
}

