/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.stage;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import nl.colorize.multimedialib.math.Point2D;
import nl.colorize.multimedialib.math.Rect;
import nl.colorize.multimedialib.stage.Align;
import nl.colorize.multimedialib.stage.Graphic2D;
import nl.colorize.multimedialib.stage.OutlineFont;
import nl.colorize.multimedialib.stage.StageLocation;
import nl.colorize.multimedialib.stage.Transform;
import nl.colorize.util.TextUtils;

public class Text
implements Graphic2D {
    private final StageLocation location = new StageLocation();
    private String text;
    private List<String> lines;
    private OutlineFont font;
    private Align align;
    private float lineHeight;

    public Text(String text, OutlineFont font, Align align) {
        this.text = text;
        this.lines = TextUtils.LINE_SPLITTER.splitToList((CharSequence)text);
        this.font = font;
        this.align = align;
        this.lineHeight = font == null ? 10.0f : (float)Math.round((float)font.getStyle().size() * 1.8f);
    }

    public Text(String text, OutlineFont font) {
        this(text, font, Align.LEFT);
    }

    public void setText(String ... lines) {
        this.setText((List<String>)ImmutableList.copyOf((Object[])lines));
    }

    public void setText(List<String> lines) {
        if (lines.isEmpty()) {
            this.text = "";
            this.lines = Collections.emptyList();
        } else if (lines.size() == 1) {
            this.text = lines.get(0);
            this.lines = TextUtils.LINE_SPLITTER.splitToList((CharSequence)this.text);
        } else {
            this.text = TextUtils.LINE_JOINER.join(lines);
            this.lines = lines;
        }
    }

    public void forLines(BiConsumer<Integer, String> callback) {
        for (int i = 0; i < this.lines.size(); ++i) {
            callback.accept(i, this.lines.get(i));
        }
    }

    @Override
    public void update(float deltaTime) {
    }

    @Override
    public Rect getStageBounds() {
        Transform globalTransform = this.getGlobalTransform();
        Point2D position = globalTransform.getPosition();
        int longestLine = this.lines.stream().mapToInt(String::length).max().orElse(1);
        float approximateWidth = this.font.getStyle().size() * longestLine;
        float approximateHeight = this.font.getStyle().size() * this.lines.size();
        return Rect.around(position, approximateWidth, approximateHeight);
    }

    public String toString() {
        Object displayText = this.text.replace("\n", " ");
        if (((String)displayText).length() > 20) {
            displayText = ((String)displayText).substring(0, 20) + "...";
        }
        return "Text [" + (String)displayText + "]";
    }

    @Override
    public StageLocation getLocation() {
        return this.location;
    }

    public String getText() {
        return this.text;
    }

    public List<String> getLines() {
        return this.lines;
    }

    public OutlineFont getFont() {
        return this.font;
    }

    public Align getAlign() {
        return this.align;
    }

    public float getLineHeight() {
        return this.lineHeight;
    }

    public void setLines(List<String> lines) {
        this.lines = lines;
    }

    public void setFont(OutlineFont font) {
        this.font = font;
    }

    public void setAlign(Align align) {
        this.align = align;
    }

    public void setLineHeight(float lineHeight) {
        this.lineHeight = lineHeight;
    }
}

