/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer;

import com.google.common.collect.Streams;
import nl.colorize.multimedialib.math.Rect;
import nl.colorize.multimedialib.renderer.KeyCode;
import nl.colorize.multimedialib.renderer.Pointer;
import nl.colorize.multimedialib.scene.Updatable;

public interface InputDevice
extends Updatable {
    public Iterable<Pointer> getPointers();

    default public boolean isPointerPressed(Rect bounds) {
        return Streams.stream(this.getPointers()).anyMatch(pointer -> pointer.isPressed(bounds));
    }

    default public boolean isPointerReleased(Rect bounds) {
        return Streams.stream(this.getPointers()).anyMatch(pointer -> pointer.isReleased(bounds));
    }

    @Deprecated
    public void clearPointerState();

    public boolean isTouchAvailable();

    public boolean isKeyboardAvailable();

    public boolean isKeyPressed(KeyCode var1);

    public boolean isKeyReleased(KeyCode var1);

    public String requestTextInput(String var1, String var2);

    public void fillClipboard(String var1);
}

