/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer;

import com.google.common.base.Preconditions;
import nl.colorize.multimedialib.math.Point2D;
import nl.colorize.multimedialib.math.Rect;

public class Pointer {
    private String id;
    private Point2D position;
    private boolean pressed;
    private boolean released;

    public Pointer(String id) {
        Preconditions.checkArgument((!id.isEmpty() ? 1 : 0) != 0, (Object)"Empty pointer ID");
        this.id = id;
        this.position = Point2D.ORIGIN;
        this.pressed = false;
        this.released = false;
    }

    public boolean isPressed(Rect bounds) {
        return this.pressed && bounds.contains(this.position);
    }

    public boolean isReleased(Rect bounds) {
        return this.released && bounds.contains(this.position);
    }

    public String getId() {
        return this.id;
    }

    public Point2D getPosition() {
        return this.position;
    }

    public boolean isPressed() {
        return this.pressed;
    }

    public boolean isReleased() {
        return this.released;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setPosition(Point2D position) {
        this.position = position;
    }

    public void setPressed(boolean pressed) {
        this.pressed = pressed;
    }

    public void setReleased(boolean released) {
        this.released = released;
    }
}

