/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.libgdx;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.google.common.base.Preconditions;
import nl.colorize.multimedialib.renderer.libgdx.GDXMediaLoader;
import nl.colorize.multimedialib.stage.FontStyle;
import nl.colorize.multimedialib.stage.OutlineFont;
import nl.colorize.util.Platform;

public class GDXBitmapFont
implements OutlineFont {
    private GDXMediaLoader fontLoader;
    private FileHandle source;
    private FontStyle style;
    private BitmapFont bitmapFont;
    private float lineOffset;

    protected GDXBitmapFont(GDXMediaLoader fontLoader, FileHandle source, FontStyle style) {
        this.fontLoader = fontLoader;
        this.source = source;
        this.style = style;
        this.bitmapFont = fontLoader.getBitmapFont(source, style);
        this.lineOffset = (float)style.size() * (0.65f * (Platform.isWindows() ? 0.5f : 1.0f));
    }

    @Override
    public OutlineFont derive(FontStyle newStyle) {
        Preconditions.checkArgument((boolean)this.style.family().equals(newStyle.family()), (Object)("Font family mismatch: expected " + this.style.family()));
        return new GDXBitmapFont(this.fontLoader, this.source, newStyle);
    }

    @Override
    public FontStyle getStyle() {
        return this.style;
    }

    public BitmapFont getBitmapFont() {
        return this.bitmapFont;
    }

    public float getLineOffset() {
        return this.lineOffset;
    }
}

