/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.teavm;

import java.util.logging.Logger;
import nl.colorize.multimedialib.math.Buffer;
import nl.colorize.multimedialib.renderer.PeerConnection;
import nl.colorize.multimedialib.renderer.teavm.PeerjsBridge;
import nl.colorize.util.LogHelper;
import nl.colorize.util.Subscribable;

public class PeerjsConnection
implements PeerConnection {
    private PeerjsBridge bridge;
    private static final Logger LOGGER = LogHelper.getLogger(PeerjsConnection.class);

    protected PeerjsConnection(PeerjsBridge bridge) {
        this.bridge = bridge;
    }

    @Override
    public String getId() {
        return this.bridge.getId();
    }

    @Override
    public Subscribable<String> connect(String peerId) {
        Subscribable subscribable = new Subscribable();
        this.bridge.connect(peerId, success -> {
            if (success) {
                subscribable.next((Object)peerId);
            } else {
                subscribable.nextError((Exception)new RuntimeException("Failed to connect to peer"));
            }
        });
        return subscribable;
    }

    @Override
    public void sendMessage(String message) {
        this.bridge.sendMessage(message);
    }

    @Override
    public Buffer<String> getReceivedMessages() {
        Buffer<String> received = new Buffer<String>();
        received.push(this.bridge.flushReceivedMessages());
        return received;
    }

    @Override
    public void close() {
        this.bridge.close();
    }
}

