/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.teavm;

import com.google.common.base.Preconditions;
import java.util.Optional;
import java.util.UUID;
import java.util.logging.Logger;
import nl.colorize.multimedialib.math.Region;
import nl.colorize.multimedialib.stage.ColorRGB;
import nl.colorize.multimedialib.stage.Image;
import nl.colorize.util.LogHelper;
import nl.colorize.util.Promise;
import org.teavm.jso.browser.Window;
import org.teavm.jso.canvas.CanvasImageSource;
import org.teavm.jso.canvas.CanvasRenderingContext2D;
import org.teavm.jso.canvas.ImageData;
import org.teavm.jso.dom.html.HTMLCanvasElement;
import org.teavm.jso.dom.html.HTMLDocument;
import org.teavm.jso.dom.html.HTMLImageElement;
import org.teavm.jso.typedarrays.Uint8ClampedArray;

public class TeaImage
implements Image {
    private UUID id = UUID.randomUUID();
    private Promise<HTMLImageElement> imagePromise;
    private Region region;
    private CanvasRenderingContext2D imageData;
    private static final Region IMAGE_LOADING_REGION = new Region(0, 0, 1, 1);
    private static final int[] UNKNOWN_RGBA = new int[]{0, 0, 0, 0};
    private static final Logger LOGGER = LogHelper.getLogger(TeaImage.class);

    protected TeaImage(Promise<HTMLImageElement> imagePromise, Region region) {
        this.imagePromise = imagePromise;
        this.region = region;
    }

    public Optional<HTMLImageElement> getImageElement() {
        return this.imagePromise.getValue();
    }

    public boolean isLoaded() {
        return this.imagePromise.getValue().isPresent();
    }

    @Override
    public Region getRegion() {
        if (this.region == null) {
            if (this.imagePromise.getValue().isEmpty()) {
                return IMAGE_LOADING_REGION;
            }
            HTMLImageElement imageElement = (HTMLImageElement)this.imagePromise.getValue().get();
            this.region = new Region(0, 0, imageElement.getWidth(), imageElement.getHeight());
        }
        return this.region;
    }

    @Override
    public TeaImage extractRegion(Region region) {
        return new TeaImage(this.imagePromise, region);
    }

    @Override
    public ColorRGB getColor(int x, int y) {
        int[] rgba = this.getImageData(x, y);
        return new ColorRGB(rgba[0], rgba[1], rgba[2]);
    }

    @Override
    public int getAlpha(int x, int y) {
        int[] rgba = this.getImageData(x, y);
        return Math.round((float)rgba[3] / 2.55f);
    }

    private int[] getImageData(int x, int y) {
        HTMLImageElement img = this.imagePromise.getValue().orElse(null);
        Region region = this.getRegion();
        if (img == null) {
            LOGGER.warning("Trying to retrieve image data when image is still loading");
            return UNKNOWN_RGBA;
        }
        if (this.imageData == null) {
            HTMLDocument document = Window.current().getDocument();
            HTMLCanvasElement canvas = (HTMLCanvasElement)document.createElement("canvas");
            canvas.setWidth(region.width());
            canvas.setHeight(region.height());
            this.imageData = (CanvasRenderingContext2D)canvas.getContext("2d");
            this.imageData.drawImage((CanvasImageSource)img, 0.0, 0.0);
        }
        ImageData pixels = this.imageData.getImageData((double)x, (double)y, 1.0, 1.0);
        Uint8ClampedArray pixelData = pixels.getData();
        return new int[]{pixelData.get(0), pixelData.get(1), pixelData.get(2), pixelData.get(3)};
    }

    public TeaImage forParentImage() {
        Preconditions.checkState((boolean)this.isLoaded(), (Object)"Image is still loading");
        if (this.region == null) {
            return this;
        }
        return new TeaImage(this.imagePromise, null);
    }

    public boolean isFullImage() {
        return this.region == null;
    }

    public String toString() {
        HTMLImageElement imageElement = this.imagePromise.getValue().orElse(null);
        if (imageElement == null) {
            return "<loading>";
        }
        return imageElement.getSrc();
    }

    public UUID getId() {
        return this.id;
    }

    public Promise<HTMLImageElement> getImagePromise() {
        return this.imagePromise;
    }
}

