/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.teavm;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nl.colorize.multimedialib.math.Point2D;
import nl.colorize.multimedialib.renderer.Canvas;
import nl.colorize.multimedialib.renderer.InputDevice;
import nl.colorize.multimedialib.renderer.KeyCode;
import nl.colorize.multimedialib.renderer.Pointer;
import nl.colorize.multimedialib.renderer.teavm.Browser;
import nl.colorize.multimedialib.renderer.teavm.CustomTouchEvent;
import nl.colorize.multimedialib.renderer.teavm.TeaGraphics;
import org.teavm.jso.browser.Window;
import org.teavm.jso.dom.events.Event;
import org.teavm.jso.dom.events.KeyboardEvent;
import org.teavm.jso.dom.events.MouseEvent;

public class TeaInputDevice
implements InputDevice {
    private Canvas canvas;
    private TeaGraphics graphics;
    private Map<String, Pointer> pointers;
    private Set<Integer> keysDown;
    private Set<Integer> keysUp;
    private static final Map<KeyCode, Integer> BROWSER_KEY_CODE_MAPPING = new ImmutableMap.Builder().put((Object)KeyCode.LEFT, (Object)37).put((Object)KeyCode.RIGHT, (Object)39).put((Object)KeyCode.UP, (Object)38).put((Object)KeyCode.DOWN, (Object)40).put((Object)KeyCode.ENTER, (Object)13).put((Object)KeyCode.SPACEBAR, (Object)32).put((Object)KeyCode.ESCAPE, (Object)27).put((Object)KeyCode.SHIFT, (Object)16).put((Object)KeyCode.BACKSPACE, (Object)8).put((Object)KeyCode.TAB, (Object)9).put((Object)KeyCode.A, (Object)65).put((Object)KeyCode.B, (Object)66).put((Object)KeyCode.C, (Object)67).put((Object)KeyCode.D, (Object)68).put((Object)KeyCode.E, (Object)69).put((Object)KeyCode.F, (Object)70).put((Object)KeyCode.G, (Object)71).put((Object)KeyCode.H, (Object)72).put((Object)KeyCode.I, (Object)73).put((Object)KeyCode.J, (Object)74).put((Object)KeyCode.K, (Object)75).put((Object)KeyCode.L, (Object)76).put((Object)KeyCode.M, (Object)77).put((Object)KeyCode.N, (Object)78).put((Object)KeyCode.O, (Object)79).put((Object)KeyCode.P, (Object)80).put((Object)KeyCode.Q, (Object)81).put((Object)KeyCode.R, (Object)82).put((Object)KeyCode.S, (Object)83).put((Object)KeyCode.T, (Object)84).put((Object)KeyCode.U, (Object)85).put((Object)KeyCode.V, (Object)86).put((Object)KeyCode.W, (Object)87).put((Object)KeyCode.X, (Object)88).put((Object)KeyCode.Y, (Object)89).put((Object)KeyCode.Z, (Object)90).put((Object)KeyCode.N1, (Object)49).put((Object)KeyCode.N2, (Object)50).put((Object)KeyCode.N3, (Object)51).put((Object)KeyCode.N4, (Object)52).put((Object)KeyCode.N5, (Object)53).put((Object)KeyCode.N6, (Object)54).put((Object)KeyCode.N7, (Object)55).put((Object)KeyCode.N8, (Object)56).put((Object)KeyCode.N9, (Object)57).put((Object)KeyCode.N0, (Object)48).put((Object)KeyCode.F1, (Object)112).put((Object)KeyCode.F2, (Object)113).put((Object)KeyCode.F3, (Object)114).put((Object)KeyCode.F4, (Object)115).put((Object)KeyCode.F5, (Object)116).put((Object)KeyCode.F6, (Object)117).put((Object)KeyCode.F7, (Object)118).put((Object)KeyCode.F8, (Object)119).put((Object)KeyCode.F9, (Object)120).put((Object)KeyCode.F10, (Object)121).put((Object)KeyCode.F11, (Object)122).put((Object)KeyCode.F12, (Object)123).put((Object)KeyCode.PLUS, (Object)187).put((Object)KeyCode.MINUS, (Object)189).build();

    public TeaInputDevice(Canvas canvas, TeaGraphics graphics) {
        this.canvas = canvas;
        this.graphics = graphics;
        this.pointers = new HashMap<String, Pointer>();
        this.keysDown = new HashSet<Integer>();
        this.keysUp = new HashSet<Integer>();
    }

    public void bindEventHandlers() {
        Window window = Window.current();
        window.addEventListener("mousedown", this::onMouseEvent);
        window.addEventListener("mouseup", this::onMouseEvent);
        window.addEventListener("mousemove", this::onMouseEvent);
        window.addEventListener("mouseout", this::onMouseEvent);
        window.addEventListener("keydown", this::onKeyDown);
        window.addEventListener("keyup", this::onKeyUp);
        window.addEventListener("custom:touchstart", this::onCustomTouchEvent, true);
        window.addEventListener("custom:touchmove", this::onCustomTouchEvent, true);
        window.addEventListener("custom:touchend", this::onCustomTouchEvent, true);
        window.addEventListener("custom:touchcancel", this::onCustomTouchEvent, true);
    }

    private void onMouseEvent(Event event) {
        if (event.getType().equals("mouseout")) {
            this.pointers.remove("mouse");
            return;
        }
        MouseEvent mouseEvent = (MouseEvent)event;
        Pointer mousePointer = this.pointers.get("mouse");
        if (mousePointer == null) {
            mousePointer = new Pointer("mouse");
            this.pointers.put("mouse", mousePointer);
        }
        Point2D position = this.getPointerCanvasPosition(mouseEvent.getPageX(), mouseEvent.getPageY());
        mousePointer.setPosition(position);
        switch (event.getType()) {
            case "mousedown": {
                mousePointer.setPressed(true);
                break;
            }
            case "mouseup": {
                mousePointer.setReleased(true);
                break;
            }
        }
        event.preventDefault();
        event.stopPropagation();
    }

    private void onKeyDown(Event event) {
        KeyboardEvent keyboardEvent = (KeyboardEvent)event;
        this.keysDown.add(keyboardEvent.getKeyCode());
        event.preventDefault();
        event.stopPropagation();
    }

    private void onKeyUp(Event event) {
        KeyboardEvent keyboardEvent = (KeyboardEvent)event;
        this.keysUp.add(keyboardEvent.getKeyCode());
        event.preventDefault();
        event.stopPropagation();
    }

    private void onCustomTouchEvent(Event event) {
        CustomTouchEvent customTouchEvent = (CustomTouchEvent)event;
        String identifier = String.valueOf(customTouchEvent.getDetail().getIdentifier());
        Pointer touchPointer = this.pointers.get(identifier);
        if (event.getType().equals("custom:touchcancel")) {
            this.pointers.remove(identifier);
            return;
        }
        if (touchPointer == null) {
            touchPointer = new Pointer(identifier);
            this.pointers.put(identifier, touchPointer);
        }
        int pageX = customTouchEvent.getDetail().getPageX();
        int pageY = customTouchEvent.getDetail().getPageY();
        touchPointer.setPosition(this.getPointerCanvasPosition(pageX, pageY));
        switch (event.getType()) {
            case "custom:touchstart": {
                touchPointer.setPressed(true);
                break;
            }
            case "custom:touchend": {
                touchPointer.setReleased(true);
                break;
            }
        }
        customTouchEvent.preventDefault();
        customTouchEvent.stopPropagation();
    }

    public void reset() {
        this.pointers.keySet().removeIf(id -> this.pointers.get(id).isReleased());
        this.keysDown.removeAll(this.keysUp);
        this.keysUp.clear();
    }

    @Override
    public Iterable<Pointer> getPointers() {
        return List.copyOf(this.pointers.values());
    }

    private Point2D getPointerCanvasPosition(int pageX, int pageY) {
        int screenX = Math.round((float)pageX * this.graphics.getDevicePixelRatio());
        int screenY = Math.round((float)pageY * this.graphics.getDevicePixelRatio());
        float canvasX = this.canvas.toCanvasX(screenX);
        float canvasY = this.canvas.toCanvasY(screenY);
        return new Point2D(canvasX, canvasY);
    }

    @Override
    public void clearPointerState() {
        this.pointers.clear();
    }

    @Override
    public boolean isTouchAvailable() {
        return Browser.isTouchSupported();
    }

    @Override
    public boolean isKeyboardAvailable() {
        return !this.isTouchAvailable();
    }

    @Override
    public boolean isKeyPressed(KeyCode keyCode) {
        int browserKeyCode = BROWSER_KEY_CODE_MAPPING.get((Object)keyCode);
        return this.keysDown.contains(browserKeyCode);
    }

    @Override
    public boolean isKeyReleased(KeyCode keyCode) {
        int browserKeyCode = BROWSER_KEY_CODE_MAPPING.get((Object)keyCode);
        return this.keysUp.contains(browserKeyCode);
    }

    @Override
    public String requestTextInput(String label, String initialValue) {
        return Window.prompt((String)label, (String)initialValue);
    }

    @Override
    public void fillClipboard(String text) {
        Browser.writeClipboard(text);
    }

    @Override
    public void update(float deltaTime) {
    }
}

