/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.teavm;

import java.io.File;
import nl.colorize.multimedialib.renderer.DisplayMode;
import nl.colorize.multimedialib.renderer.ErrorHandler;
import nl.colorize.multimedialib.renderer.GraphicsMode;
import nl.colorize.multimedialib.renderer.InputDevice;
import nl.colorize.multimedialib.renderer.MediaLoader;
import nl.colorize.multimedialib.renderer.Network;
import nl.colorize.multimedialib.renderer.Renderer;
import nl.colorize.multimedialib.renderer.pixi.PixiGraphics;
import nl.colorize.multimedialib.renderer.teavm.Browser;
import nl.colorize.multimedialib.renderer.teavm.BrowserDOM;
import nl.colorize.multimedialib.renderer.teavm.HtmlCanvasGraphics;
import nl.colorize.multimedialib.renderer.teavm.TeaGraphics;
import nl.colorize.multimedialib.renderer.teavm.TeaInputDevice;
import nl.colorize.multimedialib.renderer.teavm.TeaMediaLoader;
import nl.colorize.multimedialib.renderer.teavm.TeaNetwork;
import nl.colorize.multimedialib.renderer.three.ThreeGraphics;
import nl.colorize.multimedialib.renderer.webgl.WebGL;
import nl.colorize.multimedialib.scene.Scene;
import nl.colorize.multimedialib.scene.SceneContext;
import nl.colorize.multimedialib.stage.StageVisitor;
import nl.colorize.util.Stopwatch;
import org.teavm.jso.browser.Window;

public class TeaRenderer
implements Renderer {
    private DisplayMode displayMode;
    private TeaGraphics graphics;
    private TeaInputDevice inputDevice;
    private TeaMediaLoader mediaLoader;
    private TeaNetwork network;
    private SceneContext context;

    private TeaRenderer(DisplayMode displayMode, TeaGraphics graphics) {
        this.displayMode = displayMode;
        this.graphics = graphics;
        this.inputDevice = new TeaInputDevice(displayMode.canvas(), graphics);
    }

    @Override
    public void start(Scene initialScene, ErrorHandler errorHandler) {
        this.mediaLoader = new TeaMediaLoader(this.graphics);
        this.network = new TeaNetwork();
        this.context = new SceneContext(this, new Stopwatch());
        this.context.changeScene(initialScene);
        this.inputDevice.bindEventHandlers();
        this.graphics.init(this.mediaLoader);
        Browser.prepareAnimationLoop();
        Browser.registerErrorHandler(error -> this.handleError(errorHandler, error));
        Window.requestAnimationFrame(this::onAnimationFrame);
    }

    private void onAnimationFrame(double timestamp) {
        if (this.prepareCanvas() && this.context.syncFrame()) {
            this.renderFrame();
            this.inputDevice.reset();
        }
        Window.requestAnimationFrame(this::onAnimationFrame);
    }

    private boolean prepareCanvas() {
        int width = this.graphics.getDisplayWidth();
        int height = this.graphics.getDisplayHeight();
        if (width > 0 || height > 0) {
            this.displayMode.canvas().resizeScreen(width, height);
            return true;
        }
        return false;
    }

    private void renderFrame() {
        this.context.getFrameStats().markStart("$$frameRender");
        this.context.getStage().visit(this.graphics);
        this.context.getFrameStats().markEnd("$$frameRender");
    }

    private void handleError(ErrorHandler errorHandler, String error) {
        RuntimeException cause = new RuntimeException("JavaScript error\n\n" + error);
        errorHandler.onError(this.context, cause);
    }

    @Override
    public GraphicsMode getGraphicsMode() {
        return this.graphics.getGraphicsMode();
    }

    @Override
    public DisplayMode getDisplayMode() {
        return this.displayMode;
    }

    @Override
    public StageVisitor getGraphics() {
        return this.graphics;
    }

    @Override
    public InputDevice getInput() {
        return this.inputDevice;
    }

    @Override
    public MediaLoader getMediaLoader() {
        return this.mediaLoader;
    }

    @Override
    public Network getNetwork() {
        return this.network;
    }

    @Override
    public void takeScreenshot(File outputFile) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isDevelopmentEnvironment() {
        return BrowserDOM.getQueryString().contains("local");
    }

    @Override
    public void terminate() {
        throw new UnsupportedOperationException();
    }

    public static TeaRenderer withCanvas(DisplayMode displayMode) {
        HtmlCanvasGraphics graphics = new HtmlCanvasGraphics(displayMode.canvas());
        return new TeaRenderer(displayMode, graphics);
    }

    public static TeaRenderer withWebGL(DisplayMode displayMode) {
        WebGL graphics = new WebGL(displayMode.canvas());
        return new TeaRenderer(displayMode, graphics);
    }

    public static TeaRenderer withPixi(DisplayMode displayMode) {
        PixiGraphics graphics = new PixiGraphics(displayMode.canvas());
        return new TeaRenderer(displayMode, graphics);
    }

    public static TeaRenderer withThree(DisplayMode displayMode) {
        ThreeGraphics graphics = new ThreeGraphics(displayMode.canvas());
        return new TeaRenderer(displayMode, graphics);
    }
}

