/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.webgl;

import java.util.Arrays;
import nl.colorize.multimedialib.stage.ColorRGB;
import org.teavm.jso.webgl.WebGLBuffer;
import org.teavm.jso.webgl.WebGLTexture;

public class VertexData {
    private int vertices;
    private WebGLBuffer vertexBuffer;
    private WebGLTexture texture;
    private WebGLBuffer textureCoordinateBuffer;
    private float[] color = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
    private float[] position = new float[]{0.0f, 0.0f};
    private float[] rotation = new float[]{(float)Math.sin(0.0), (float)Math.cos(0.0)};
    private float[] scale = new float[]{1.0f, 1.0f};

    public void setPosition(float x, float y) {
        this.position[0] = x;
        this.position[1] = y;
    }

    public void setColor(ColorRGB rgb, float alpha) {
        this.color[0] = (float)rgb.r() / 255.0f;
        this.color[1] = (float)rgb.g() / 255.0f;
        this.color[2] = (float)rgb.b() / 255.0f;
        this.color[3] = alpha / 100.0f;
    }

    public void setRotationInRadians(float radians) {
        this.rotation[0] = (float)Math.sin(radians);
        this.rotation[1] = (float)Math.cos(radians);
    }

    public void setScale(float scaleX, float scaleY) {
        this.scale[0] = scaleX / 100.0f;
        this.scale[1] = scaleY / 100.0f;
    }

    public int getVertices() {
        return this.vertices;
    }

    public WebGLBuffer getVertexBuffer() {
        return this.vertexBuffer;
    }

    public WebGLTexture getTexture() {
        return this.texture;
    }

    public WebGLBuffer getTextureCoordinateBuffer() {
        return this.textureCoordinateBuffer;
    }

    public float[] getColor() {
        return this.color;
    }

    public float[] getPosition() {
        return this.position;
    }

    public float[] getRotation() {
        return this.rotation;
    }

    public float[] getScale() {
        return this.scale;
    }

    public void setVertices(int vertices) {
        this.vertices = vertices;
    }

    public void setVertexBuffer(WebGLBuffer vertexBuffer) {
        this.vertexBuffer = vertexBuffer;
    }

    public void setTexture(WebGLTexture texture) {
        this.texture = texture;
    }

    public void setTextureCoordinateBuffer(WebGLBuffer textureCoordinateBuffer) {
        this.textureCoordinateBuffer = textureCoordinateBuffer;
    }

    public void setColor(float[] color) {
        this.color = color;
    }

    public void setPosition(float[] position) {
        this.position = position;
    }

    public void setRotation(float[] rotation) {
        this.rotation = rotation;
    }

    public void setScale(float[] scale) {
        this.scale = scale;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VertexData)) {
            return false;
        }
        VertexData other = (VertexData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getVertices() != other.getVertices()) {
            return false;
        }
        WebGLBuffer this$vertexBuffer = this.getVertexBuffer();
        WebGLBuffer other$vertexBuffer = other.getVertexBuffer();
        if (this$vertexBuffer == null ? other$vertexBuffer != null : !this$vertexBuffer.equals(other$vertexBuffer)) {
            return false;
        }
        WebGLTexture this$texture = this.getTexture();
        WebGLTexture other$texture = other.getTexture();
        if (this$texture == null ? other$texture != null : !this$texture.equals(other$texture)) {
            return false;
        }
        WebGLBuffer this$textureCoordinateBuffer = this.getTextureCoordinateBuffer();
        WebGLBuffer other$textureCoordinateBuffer = other.getTextureCoordinateBuffer();
        if (this$textureCoordinateBuffer == null ? other$textureCoordinateBuffer != null : !this$textureCoordinateBuffer.equals(other$textureCoordinateBuffer)) {
            return false;
        }
        if (!Arrays.equals(this.getColor(), other.getColor())) {
            return false;
        }
        if (!Arrays.equals(this.getPosition(), other.getPosition())) {
            return false;
        }
        if (!Arrays.equals(this.getRotation(), other.getRotation())) {
            return false;
        }
        return Arrays.equals(this.getScale(), other.getScale());
    }

    protected boolean canEqual(Object other) {
        return other instanceof VertexData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getVertices();
        WebGLBuffer $vertexBuffer = this.getVertexBuffer();
        result = result * 59 + ($vertexBuffer == null ? 43 : $vertexBuffer.hashCode());
        WebGLTexture $texture = this.getTexture();
        result = result * 59 + ($texture == null ? 43 : $texture.hashCode());
        WebGLBuffer $textureCoordinateBuffer = this.getTextureCoordinateBuffer();
        result = result * 59 + ($textureCoordinateBuffer == null ? 43 : $textureCoordinateBuffer.hashCode());
        result = result * 59 + Arrays.hashCode(this.getColor());
        result = result * 59 + Arrays.hashCode(this.getPosition());
        result = result * 59 + Arrays.hashCode(this.getRotation());
        result = result * 59 + Arrays.hashCode(this.getScale());
        return result;
    }

    public String toString() {
        return "VertexData(vertices=" + this.getVertices() + ", vertexBuffer=" + String.valueOf(this.getVertexBuffer()) + ", texture=" + String.valueOf(this.getTexture()) + ", textureCoordinateBuffer=" + String.valueOf(this.getTextureCoordinateBuffer()) + ", color=" + Arrays.toString(this.getColor()) + ", position=" + Arrays.toString(this.getPosition()) + ", rotation=" + Arrays.toString(this.getRotation()) + ", scale=" + Arrays.toString(this.getScale()) + ")";
    }
}

